% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/electoralTool.R
\docType{methods}
\encoding{UTF-8}
\name{politicalDiversity}
\alias{politicalDiversity}
\alias{politicalDiversity,ANY-method}
\alias{politicalDiversity,numeric,character,integer,numeric,ANY-method}
\title{Political Diversity Indices}
\usage{
politicalDiversity(x, index = "laakso/taagepera", margin = 1,
  base = exp(1))

\S4method{politicalDiversity}{ANY}(x, index = "laakso/taagepera",
  margin = 1, base = exp(1))
}
\arguments{
\item{x}{A data.frame, a matrix-like, or a vector containing values for the number of votes or seats each party received.}

\item{index}{The type of index desired, one of "laakso/taagepera",  "golosov", "herfindahl", "gini", "shannon", "simpson", "invsimpson".}

\item{margin}{The margin for which the index is computed.}

\item{base}{The logarithm base used in some indices, such as the "shannon" index.}
}
\description{
Analyzes political diversity in an electoral unity or across unities. It provides methods for estimating the effective number of parties and other fragmentation/concetration measures. The intuition of these coefficients is to counting parties while weighting them by their relative political--or electoral strength.
}
\details{
Very often, political analysts say things like \sQuote{two-party system} and \sQuote{multi-party system} to refer to a particular kind of political party system. However, these terms alone does not tell exactly how fragmented--or concentrated a party system actually is. For instance, after the 2010 general election, 22 parties obtained representation in the Lower Chamber in Brazil. Nonetheless, among these 22 parties, nine parties together returned only 28 MPs. Thus, an index to assess the weigh or the \bold{Effective Number of Parties} is important and helps to go beyond the simple count of parties in a legislative branch.

A widely accepted algorithm was proposed by M. Laakso and R. Taagepera: \deqn{N = \frac{1}{\sum p_i^2}}{N = 1/ \sum p_i^2}, where \bold{N} denotes the effective number of parties and \bold{p_i} denotes the \eqn{it^h} party's fraction of the seats.

In fact, this formula may be used to compute the vote share for each party. This formula is the reciprocal of a well-known concentration index (\bold{the Herfindahl-Hirschman index}) used in economics to study the degree to which ownership of firms in an industry is concentrated. Laakso and Taagepera correctly saw that the effective number of parties is simply an instance of the inverse measurement problem to that one. This index makes rough but fairly reliable international comparisons of party systems possible.
\bold{The Inverse Simpson index},
\deqn{ 1/ \lambda = {1 \over\sum_{i=1}^R p_i^2} = {}^2D}
Where \eqn{\lambda} equals the probability that two types taken at random from the dataset (with replacement) represent the same type. This simply equals true fragmentation of order 2, i.e. the effective number of parties that is obtained when the weighted arithmetic mean is used to quantify average proportional diversity of political parties in the election of interest.

Another measure is the \bold{Least squares index (lsq)}, which measures the disproportionality produced by the election. Specifically, by the disparity between the distribution of votes and seats allocation.

Recently, Grigorii Golosov proposed a new method for computing the effective number of parties  in which both larger and smaller parties are not attributed unrealistic scores as those resulted by using the Laakso/Taagepera index.I will call this as (\bold{Golosov}) and is given by the following formula: \deqn{N = \sum_{i=1}^{n}\frac{p_{i}}{p_{i}+p_{i}^{2}-p_{i}^{2}}}
}
\examples{
# Here are some examples, help yourself:
# The wikipedia examples

A <- c(.75,.25);
B <- c(.75,.10,rep(0.01,15))
C <- c(.55,.45);

# The index by "laakso/taagepera" is the default
politicalDiversity(A)
politicalDiversity(B)

# Using Grigorii Golosov method gives:
politicalDiversity(B, index="golosov")
politicalDiversity(C, index="golosov")

# The 1980 presidential election in the US (vote share):
US1980 <- c("Democratic"=0.410, "Republican"=0.507,
"Independent"=0.066, "Libertarian"=0.011, "Citizens"=0.003,
"Others"=0.003)

politicalDiversity(US1980)

politicalDiversity(US1980, index= "herfindahl")

politicalDiversity(US1980, index = "H") # will match Herfindahl

# The 1999 Finland election:
votes_1999 <- c(612963, 600592, 563835,
291675, 194846, 137330, 111835, 28084, 26440, 28549, 20442,
10378, 10104, 5451, 5194, 4481, 3903, 3455, 21734)

seats_1999 <- c(51, 48, 46, 20, 11, 11, 10, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0)

# 2010 Brazilian legislative election

votes_2010 = c("PT"=13813587, "PMDB"=11692384, "PSDB"=9421347,
"DEM"=6932420, "PR"=7050274, "PP"=5987670, "PSB"=6553345,
"PDT"=4478736, "PTB"=3808646, "PSC"=2981714, "PV"=2886633,
"PC do B"=2545279, "PPS"=2376475, "PRB"=1659973, "PMN"=1026220,
"PT do B"=605768, "PSOL"=968475, "PHS"=719611, "PRTB"=283047,
"PRP"=232530, "PSL"=457490,"PTC"=563145)

seats_2010 = c("PT"=88, "PMDB"=79, "PSDB"=53, "DEM"=43,
"PR"=41, "PP"=41, "PSB"=34, "PDT"=28, "PTB"=21, "PSC"=17,
"PV"=15, "PC do B"=15, "PPS"=12, "PRB"=8, "PMN"=4, "PT do B"=3,
 "PSOL"=3, "PHS"=2, "PRTB"=2, "PRP"=2, "PSL"=1,"PTC"=1)

politicalDiversity(seats_2010)

politicalDiversity(seats_2010, index= "golosov")
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}.
}
\references{
Gallagher, Michael and Paul Mitchell (2005) \emph{The Politics of Electoral Systems.} Oxford University Press.

Golosov, Grigorii (2010) The Effective Number of Parties: A New Approach, \emph{Party Politics,} \bold{16:} 171-192.

Laakso, Markku and Rein Taagepera (1979) Effective Number of Parties: A Measure with Application to West Europe, \emph{Comparative Political Studies,} \bold{12:} 3-27.

Nicolau, Jairo (2008) \emph{Sistemas Eleitorais.} Rio de Janeiro, FGV.

Taagepera, Rein and Matthew S. Shugart (1989) \emph{Seats and Votes: The Effects and Determinants of Electoral Systems.} New Haven: Yale University Press.
}
\seealso{
\code{\link{cox.shugart}}, \code{\link{inv.cox.shugart}}, \code{\link{farina}}, \code{\link{grofman}}, \code{\link{gallagher}}, \code{\link{lijphart}}. For more details see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}
}
\keyword{Basics,}
\keyword{Diversity,}
\keyword{Elections}

