ncut.range <-
  function(
    data,
    step = 1,
    max.runs = 20,
    outcome,
    conditions,
    incl.cut = 1,
    n.cut = 1,
    include = "",
    dir.exp = "",
    ...
  )
  {
    
    suppressWarnings(init.sol <- minimize(data = data,
                                          outcome  = outcome,
                                          conditions = conditions,
                                          incl.cut = incl.cut,
                                          n.cut = n.cut,
                                          include = include,
                                          dir.exp = dir.exp,
                                          ...))
    
    # Test range n.cut lower:
    suppressWarnings(sol <- minimize(data = data,
                                     outcome  = outcome,
                                     conditions = conditions,
                                     incl.cut = incl.cut,
                                     n.cut = n.cut,
                                     include = include,
                                     dir.exp = dir.exp,
                                     ...))
    if (is.null(init.sol$i.sol)) {
      is = init.sol$solution[[1]]
      s = sol$solution[[1]]
    }
    else {
      is = init.sol$i.sol$C1P1$solution[[1]]
      s = sol$i.sol$C1P1$solution[[1]]
    }
    n.cut.tl = n.cut
    while (setequal(is,s))
    { print("Searching for thresholds, this takes me a while for now, sorry...")
      n.cut.tl = n.cut.tl - step
      if (n.cut.tl < 1) { break }
      sol <- suppressWarnings(minimize(data = data,
                                       outcome  = outcome,
                                       conditions = conditions,
                                       incl.cut = incl.cut,
                                       n.cut = n.cut.tl,
                                       include = include,
                                       dir.exp = dir.exp,
                                       ...))
      if (is.null(init.sol$i.sol)) {
        s = sol$solution[[1]]
      }
      else {
        s = sol$i.sol$C1P1$solution[[1]]
      }
    }
    
    # Test range n.cut upper:
    suppressWarnings(sol <- minimize(data = data,
                                     outcome  = outcome,
                                     conditions = conditions,
                                     incl.cut = incl.cut,
                                     n.cut = n.cut,
                                     include = include,
                                     dir.exp = dir.exp,
                                     ...))
    if (is.null(init.sol$i.sol)) {
      is = init.sol$solution[[1]]
      s = sol$solution[[1]]
    }
    else {
      is = init.sol$i.sol$C1P1$solution[[1]]
      s = sol$i.sol$C1P1$solution[[1]]
    }
    n.cut.tu = n.cut
    while (setequal(is,s))
    { print("Searching for thresholds, this takes me a while for now, sorry...")
      n.cut.tu = n.cut.tu + step
      if (n.cut.tl == nrow(data)) { break }
      sol <- suppressWarnings(minimize(data = data,
                                       outcome  = outcome,
                                       conditions = conditions,
                                       incl.cut = incl.cut,
                                       n.cut = n.cut.tu,
                                       include = include,
                                       dir.exp = dir.exp,
                                       ...))
      if (is.null(init.sol$i.sol)) {
        s = sol$solution[[1]]
      }
      else {
        s = sol$i.sol$C1P1$solution[[1]]
      }
    }
    
    NCUT = c(n.cut.tl+step, n.cut.tu-step)
    TH <- data.frame(NCUT)
    row.names(TH) <- c("Lower bound", "Upper bound")
    cat(c("N.Cut: ","Lower bound ", n.cut.tl+step, "Threshold ", n.cut , "Upper bound ", n.cut.tu - step, "\n"))
    invisible(TH)
  }  