% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SimInf_model.R
\docType{methods}
\name{run}
\alias{run}
\alias{run,SimInf_model-method}
\title{Run the SimInf stochastic simulation algorithm}
\usage{
run(model, threads = NULL, seed = NULL)

\S4method{run}{SimInf_model}(model, threads = NULL, seed = NULL)
}
\arguments{
\item{model}{The siminf model to run.}

\item{threads}{Number of threads. Default is NULL, i.e. to use the
number of available processors.}

\item{seed}{Random number seed. Default is NULL, i.e. to use a
time-seed.}
}
\value{
\code{SimInf_model} with result from simulation.
}
\description{
Run the SimInf stochastic simulation algorithm
}
\examples{
## Create a 'SISe' demo model with 1 node and
## initialize it to run over 1000 days.
model <- demo_model(nodes = 1, days = 1000, model = "SISe")
run(model)
}
