% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\name{shift_matrix<-}
\alias{shift_matrix<-}
\title{Set the shift matrix for a \code{SimInf_model} object}
\usage{
shift_matrix(model) <- value
}
\arguments{
\item{model}{The \code{model} to set the shift matrix
\code{events@N}.}

\item{value}{A matrix.}
}
\value{
\code{SimInf_model} object
}
\description{
Utility function to set \code{events@N} in a \code{SimInf_model}
object, see \code{\linkS4class{SimInf_events}}
}
\examples{
## Create an SIR model
model <- SIR(u0 = data.frame(S = 99, I = 1, R = 0),
             tspan = 1:5, beta = 0.16, gamma = 0.077)

## Set the shift matrix
shift_matrix(model) <- matrix(c(2, 1, 0), nrow = 3)

## Extract the shift matrix from the model
shift_matrix(model)
}
