% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ss.data.wbx}
\alias{ss.data.wbx}
\title{Woodboard location for profiles}
\format{
A vector with 500 items for the locations (\emph{in}).
}
\source{
Example 10.1 in the reference below. It is a variation of the one
introduced by Walker (2002).
}
\usage{
data("ss.data.wbx")
}
\description{
This data set contains the 500 locations at which the density of a
0.5\emph{in}-thick engineered woodboard is measured, i.e., 0.001 \emph{in}
apart
}
\details{
This data set illustrates concepts in the book ``Quality Control with R''.
This data set should be used along with the \code{\link{ss.data.wby}} data
set.
}
\examples{

data(ss.data.wbx)
data(ss.data.wby)
plotProfiles(profiles = ss.data.wby,
    x = ss.data.wbx)

}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.

Walker, E. amd Wright, W (2002) Comparing curves with additive models.
\emph{J. Qual. Technol.} \bold{34}(1), 118--129
}
\seealso{
\code{\link{ss.data.wby}}
}
\keyword{datasets}
