% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss.rr.R
\name{ss.rr}
\alias{ss.rr}
\title{Gage R & R (Measurement System Assessment)}
\usage{
ss.rr(var, part, appr, lsl = NA, usl = NA, sigma = 6, data,
  main = "Six Sigma Gage R&R Study", sub = "", alphaLim = 0.05,
  errorTerm = "interaction", digits = 4)
}
\arguments{
\item{var}{Measured variable}

\item{part}{Factor for parts}

\item{appr}{Factor for appraisers (operators, machines, ...)}

\item{lsl}{Numeric value of lower specification limit used with USL to calculate Study Variation as \%Tolerance}

\item{usl}{Numeric value of upper specification limit used with LSL to calculate Study Variation as \%Tolerance}

\item{sigma}{Numeric value for number of std deviations to use in calculating Study Variation}

\item{data}{Data frame containing the variables}

\item{main}{Main title for the graphic output}

\item{sub}{Subtitle for the graphic output (recommended the name of the project)}

\item{alphaLim}{Limit to take into account interaction}

\item{errorTerm}{Which term of the model should be used as error term (for the model with interation)}

\item{digits}{Number of decimal digits for output}
}
\value{
Analysis of Variance Table/s. Variance composition and \%Study Var. Graphics.
\item{anovaTable}{The ANOVA table of the model}
\item{anovaRed}{The ANOVA table of the reduced model (without interaction, only
if interaction not significant)}
\item{varComp}{A matrix with the contribution of each component to the 
	total variation}
\item{studyVar}{A matrix with the contribution to the study variation}
\item{ncat}{Number of distinct categories}
}
\description{
Performs Gage R&R analysis for the assessment of the measurement 
system of a process. Related to the Measure phase of the DMAIC
strategy of Six Sigma.
}
\details{
Performs an R&R study for the measured variable, taking into account
  part and appraiser factors. It outputs the sources of Variability, and
  six graphs: bar chart with the sources of Variability, plots by
  appraiser, part and interaction and x-bar and R control charts.
}
\note{
The F test for the main effects in the ANOVA table is usually made 
taken the operator/appraisal
interaction as the error term (repeated measures model), thereby computing F as
$MS_{factor}/MS_{interaction}$, e.g. in appendix A of AIAG MSA manual, 
in Montgomery (2009) and by statistical software such as Minitab.
However, in the example provided in page 127 of the AIAG MSA Manual, the
F test is performed as $MS_{factor}/MS_{equipment}$, i.e., repeatability.
Thus, since version 0.9-3 of the SixSigma package, a new argument
\code{errorTerm} controls which term should be used as error Term, one of 
"interaction", "repeatability". 

Argument \code{alphaLim} is used as upper limit to use the full model, i.e.,
with interaction. Above this value for the interaction effect, the 
ANOVA table without the interaction effect is also obtained, and the variance
components are computed pooling the interaction term with the repeatibility.
}
\examples{
ss.rr(time1, prototype, operator, data = ss.data.rr, 
	sub = "Six Sigma Paper Helicopter Project", 
	alphaLim = 0.05,
	errorTerm = "interaction")

}
\author{
EL Cano with contributions by Kevin C Limburg
}
\references{
Automotive Industry Action Group. (2010). Measurement Systems Analysis
(Fourth Edition). AIAG.

Cano, Emilio L., Moguerza, Javier M. and Redchuk, Andres. 2012.
\emph{Six Sigma with {R}. Statistical Engineering for Process
  Improvement}, Use R!, vol. 36. Springer, New York.
  \url{http://www.springer.com/statistics/book/978-1-4614-3651-5}.

Montgomery, D. C. (2009). Introduction to Statistical Quality Control
(Sixth Edition ed.). New York: Wiley & Sons, Inc.
}
\seealso{
\code{\link{ss.data.rr}}
}
\keyword{Gauge}
\keyword{MSA}
\keyword{R&R}
\keyword{repeatability}
\keyword{reproducibility}

