% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSurvIC.R
\name{sim.survIC}
\alias{sim.survIC}
\title{Simulate interval censored survival data}
\usage{
\method{sim}{survIC}(x, n, compliance = 1, latent = TRUE,
  keep.inspectiontimes = FALSE, ...)
}
\arguments{
\item{x}{An \code{survIC} object as obtained with
\code{survIC}}

\item{n}{Number of observations}

\item{compliance}{Probability of missing an inspection time.}

\item{latent}{if TRUE keep the latent event times}

\item{keep.inspectiontimes}{if \code{TRUE} keep the inspection
times.}

\item{...}{Extra arguments given to \code{sim}}
}
\value{
A data set with interval censored observations
}
\description{
Function to simulate interval censored survival data
}
\details{
Based on the functionality of the lava PACKAGE
}
\examples{
library(lava)
example(survIC)
help(survIC)
ol <- survIC()
dat.ol <- sim(ol,10)
}
\author{
Thomas Alexander Gerds
}
