% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graven2017.R
\docType{data}
\name{Graven2017}
\alias{Graven2017}
\title{Compiled records of radicarbon in atmospheric CO2 for historical simulations in CMIP6}
\format{
A data frame with 166 rows and 4 variables.
  \describe{
    \item{\code{Year.AD}}{Year (AD).}
    \item{\code{NH}}{Delta14C for the northern hemisphere, betwen 30N to 90N latitude. Values in per mil.}
    \item{\code{Tropics}}{Delta14C for the tropics, between 30N to 30S latitude. Values in per mil.}
    \item{\code{SH}}{Delta14C for the southern hemisphere, between 30S to 90S latitude. Values in per mil.}
  }
}
\source{
<https://doi.org/10.22033/ESGF/input4MIPs.1602>
}
\usage{
data(Graven2017)
}
\description{
Historical Delta-14C in atmospheric CO2 used as forcing dataset for CMIP6 simulation experiments. 
Data is reported for three hemispheric zones, for the period 1850-2015.
}
\details{
All details about the derivation of this dataset are provided in Graven et al. (2017)
}
\examples{
matplot(Graven2017[,1], Graven2017[,-1],type="l",
       lty=1, xlab="Year AD", ylab="Delta14C (per mil)", bty="n")
legend("topleft",names(Graven2017[,-1]), lty=1, col=1:3, bty="n")

}
\references{
Graven, Heather; Allison, Colin; Etheridge, David; Hammer, Samuel; Keeling, Ralph; Levin, Ingeborg; 
Meijer, Harro A. J.; Rubino, Mauro; Tans, Pieter; Trudinger, Cathy; Vaughn, Bruce; White, James (2017). 
Compiled Historical Record of Atmospheric Delta14CO2 version 2.0. Earth System Grid Federation. 
https://doi.org/10.22033/ESGF/input4MIPs.1602

Graven, H., Allison, C. E., Etheridge, D. M., Hammer, S., Keeling, R. F., Levin, I., Meijer, 
H. A. J., Rubino, M., Tans, P. P., Trudinger, C. M., Vaughn, B. H., and White, J. W. C. 2017. 
Compiled records of carbon isotopes in atmospheric CO2 for historical simulations in CMIP6, 
Geosci. Model Dev., 10, 4405–4417, https://doi.org/10.5194/gmd-10-4405-2017.
}
\author{
Carlos Sierra \email{csierra@bgc-jena.mpg.de}
}
\keyword{datasets}
