% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropyRatePerTime.R
\name{entropyRatePerTime}
\alias{entropyRatePerTime}
\title{Entropy rate per time}
\usage{
entropyRatePerTime(A, u)
}
\arguments{
\item{A}{A constant compartmental square matrix with cycling rates in the
diagonal and transfer rates in the off-diagonal.}

\item{u}{A one-column matrix defining the amount of inputs per compartment.}
}
\value{
A scalar value with the entropy rate per time
}
\description{
Computes the entropy rate per time of the Markov chain generated by the compartmental system
}
\examples{
B6=matrix(c(-1,1,0,0,-1,1,0,0,-1),3,3); u6=matrix(c(1,0,0))
entropyRatePerTime(A=B6, u=u6)
}
\references{
Metzler, H. (2020). Compartmental systems as Markov chains : age, 
transit time, and entropy (T. Oertel-Jaeger, I. Pavlyukevich, and C. Sierra, 
Eds.) 
[PhD thesis](https://suche.thulb.uni-jena.de/Record/1726091651)
}
