% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{events}
\alias{completed}
\alias{completed,simList,character-method}
\alias{completed,simList,missing-method}
\alias{completed<-}
\alias{completed<-,simList-method}
\alias{events}
\alias{events,simList,character-method}
\alias{events,simList,missing-method}
\alias{events<-}
\alias{events<-,simList-method}
\alias{simList-accessors-events}
\title{Simulation event lists}
\usage{
events(object, unit)

\S4method{events}{simList,character}(object, unit)

\S4method{events}{simList,missing}(object, unit)

events(object) <- value

\S4method{events}{simList}(object) <- value

completed(object, unit)

\S4method{completed}{simList,character}(object, unit)

\S4method{completed}{simList,missing}(object, unit)

completed(object) <- value

\S4method{completed}{simList}(object) <- value
}
\arguments{
\item{object}{A \code{simList} simulation object.}

\item{unit}{Character. One of the time units used in \code{SpaDES}.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{events} and \code{completed} slots of a
\code{simList} object.
By default, the event lists are shown when the \code{simList} object is printed,
thus most users will not require direct use of these methods.
\tabular{ll}{
   \code{events} \tab Scheduled simulation events (the event queue).\cr
   \code{completed} \tab Completed simulation events.\cr
}
}
\details{
Currently, only get and set methods are defined. Subset methods are not.
}
\note{
Each event is represented by a \code{\link{data.table}} row consisting of:
       \tabular{ll}{
         \code{eventTime} \tab The time the event is to occur.\cr
         \code{moduleName} \tab The module from which the event is taken.\cr
         \code{eventType} \tab A character string for the programmer-defined event type.\cr
       }
}
\seealso{
\code{\link{simList-class}},
         \code{\link{simList-accessors-envir}},
         \code{\link{simList-accessors-modules}},
         \code{\link{simList-accessors-params}},
         \code{\link{simList-accessors-times}}.
}

