% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterToContourPoly.R
\name{rasterToContourPoly}
\alias{rasterToContourPoly}
\title{Create a SpatialPolygonsDataFrame from a Raster}
\usage{
rasterToContourPoly(r, nclass = 8, breaks = NULL, mask = NULL)
}
\arguments{
\item{r}{raster; the raster must contain only positive values.}

\item{nclass}{numeric; a number of class.}

\item{breaks}{numeric; a vector of break values.}

\item{mask}{SpatialPolygonsDataFrame; mask used to clip contour shapes. 
The mask should have a smaller extent than r.}
}
\value{
The ouput of the function is a SpatialPolygonsDataFrame. 
The data frame of the outputed SpatialPolygonsDataFrame contains four fields: 
id (id of each polygon), min and max (minimum and maximum breaks of the polygon), 
center (central values of classes)
}
\description{
Deprecated. 
This function creates a contour SpatialPolygonsDataFrame from a raster.
}
\details{
This function uses the rgeos package.
}
\examples{
data("spatData")
\dontrun{
mystewart <- stewart(knownpts = spatPts, varname = "Capacite",
                     typefct = "exponential", span = 1000, beta = 3,
                     resolution = 50, mask = spatMask)
# Create a raster of potentials values
mystewartraster <- rasterStewart(x = mystewart)
# Create contour SpatialLinesDataFrame
contourpoly <- rasterToContourPoly(r = mystewartraster,
                                   nclass = 6,
                                   mask = spatMask)
# Created breaks
bks <- sort(unique(c(contourpoly$min, contourpoly$max)))
# Display the map
library(cartography)
library(sp)
opar <- par(mar = c(0,0,1.2,0))
choroLayer(spdf = contourpoly,
           df = contourpoly@data,
           var = "center", legend.pos = "topleft",
           breaks = bks, border = "grey90",
           lwd = 0.2,
           legend.title.txt = "Potential number\\nof beds in the\\nneighbourhood",
           legend.values.rnd = 0)
plot(spatMask, add = TRUE)
propSymbolsLayer(spdf = spatPts, df = spatPts@data, var = "Capacite",
                 legend.title.txt = "Number of beds",
                 col = "#ff000020")
layoutLayer(title = "Global Accessibility to Public Hospitals",
            south = TRUE, sources = "", author = "")
par(opar)
}
}
\seealso{
\link{stewart}, \link{rasterStewart}.
}
