\name{tess.plot.output}
\alias{tess.plot.output}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{tess.plot.output: Plotting the output of a diversification rate estimation including mass-extinction events.}
\description{tess.output.summary plots the output generated by a tess.process.output(...) command.}
\usage{
tess.plot.output(output,
                 fig.types=c("speciation rates",
                             "speciation shift times",
                             "speciation Bayes factors",
                             "extinction rates",
                             "extinction shift times",
                             "extinction Bayes factors",
                             "net-diversification rates",
                             "relative-extinction rates",
                             "mass extinction times",
                             "mass extinction Bayes factors"),
                 xlab="million years ago",
                 col=NULL,
                 col.alpha=50,
                 xaxt="n",
                 yaxt="s",
                 pch=19,
                 plot.tree=FALSE,
                            ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{output}{The processed output for plotting.}
  \item{fig.types}{Which aspects of the model to visualize. See details for a complete description.}
  \item{xlab}{The label of the x-axis. By default, millions of years.}
  \item{col}{Colors used for printing. Must be of same length as fig.types.}
  \item{col.alpha}{Alpha channel parameter for credible intervals.}
  \item{xaxt}{The type of x-axis to plot. By default, no x-axis is plotted (recommended).}
  \item{yaxt}{The type of y-axis to plot.}
  \item{pch}{The type of points to draw (if points are drawn).}
  \item{plot.tree}{Are we plotting the tree too?}
  \item{...}{Arguments delegated to plot()}
}

\details{

This function generates visual summaries of the CoMET analysis in the output object.
The argument fig.types specifies the aspects of the model to summarize.
Valid options are:
  \itemize{
    \item{speciation rates: }{Plots the interval-specific speciation rates.}
    \item{speciation shift times: }{Plots the posterior probability of at least one speciation-rate shift for each interval.}
    \item{speciation Bayes factors: }{Plots the Bayes factor support for at least one speciation-rate shift for each interval (as 2 ln BF).}
    \item{extinction rates: }{Plots the interval-specific extinction rates.}
    \item{extinction shift times: }{Plots the posterior probability of at least one extinction-rate shift for each interval.}
    \item{extinction Bayes factors: }{Plots the Bayes factor support for at least one extinction-rate shift for each interval (as 2 ln BF).}
    \item{net-diversification rates}{Plots the interval-specific net-diversification rates.}
    \item{relative-extinction rates}{Plots the interval-specific relative-extinction rates.}
    \item{mass extinction times: }{Plots the posterior probability of at least one mass-extinction event for each interval.}
    \item{mass extinction Bayes factors: }{Plots the Bayes factor support for at least one mass-extinction event for each interval (as 2 ln BF).}
  }


%  c("speciation rates","speciation change times","speciation Bayes factors",
%                                               "extinction rates","extinction change times","extinction Bayes factors",
%                                               "mass extinction times","mass extinction Bayes factors")

}

\author{Michael R. May}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\examples{
# Load the data, compute the sampling fraction rho
data(conifers)
totalConiferSpecies <- 630
sampledConiferSpecies <- conifers$Nnode+1
rho <- sampledConiferSpecies / totalConiferSpecies

# Run a tess analysis
tess.analysis(tree = conifers,
              initialSpeciationRate=c(1.0),
              initialExtinctionRate=c(0.5),
              empiricalHyperPriors = FALSE,
              numExpectedRateChanges = log(2),
              numExpectedMassExtinctions = log(2),
              samplingProbability = rho,
              MAX_ITERATIONS = 500,
              BURNIN = 500)

# Process the output
coniferOutput <- tess.process.output(dir=getwd(),
                                     numExpectedRateChanges=log(2),
                                     numExpectedMassExtinctions=log(2))

# Plot the output
tess.plot.output(coniferOutput)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models }
\keyword{ htest }
%\keyword{ birth-death }% __ONLY ONE__ keyword per line
