% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_TL.MAAD.fit.Q.R
\name{calc_TL.MAAD.fit.Q}
\alias{calc_TL.MAAD.fit.Q}
\title{Estimation of the palaeodose (Q) with the MAAD protocol}
\usage{
calc_TL.MAAD.fit.Q(LxTx, LxTx.error, doses,
  fitting.parameters = list(fit.method = "LIN", fit.weighted = FALSE))
}
\arguments{
\item{LxTx}{\link{numeric} (\bold{required}): Lx/Tx vector}

\item{LxTx.error}{\link{numeric} (\bold{required}): Error for the Lx/Tx vector}

\item{doses}{\link{numeric} (\bold{required}): doses vector}

\item{fitting.parameters}{\link{list} (with default): fitting parameters. See details.}
}
\value{
The function provides an \linkS4class{TLum.Results} object containing: \cr
 \describe{
   \item{\code{GC}}{
     \linkS4class{lm}: fitting result.}
   \item{\code{Q}}{
     \link{numeric}: equivalent dose estimation}
   \item{\code{Q.error}}{
     \link{numeric}: Error for the equivalent dose estimation}
   \item{\code{summary}}{
     \link{numeric}: parameters of the fitting result.}
 }
}
\description{
Internal function called by \link{analyse_TL.MAAD}. \cr
This function makes a first estimation of the palaeodose based on a doses vector and a Lx/Tx vector provided. \cr
See details for more information.
}
\details{
This function estimates the equivalent dose before any supralineary correction based on the doses vector and the Lx/Tx matrix provided. \cr
Different fitting methods are available (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}).
Moreover, the fitting can be weigthed or not. \cr

#' \bold{Fitting parameters} \cr
The fitting parameters are:  \cr
\describe{
 \item{\code{method}}{
   \link{character}: Fitting method (\code{LIN}, \code{EXP}, \code{EXP+LIN} or \code{EXP+EXP}).}
 \item{\code{fit.weighted}}{
   \link{logical}: If the fitting is weighted or not.}
 \item{\code{fit.use.slope}}{
   \link{logical}: If the slope of the Q growth curve is reused for the supralinearity correction.}
 \item{\code{fit.rDoses.min}}{
   \link{numeric}: lowest regenerative dose used for the fitting.}
 \item{\code{fit.rDoses.max}}{
   \link{numeric}: Highest regenerative dose used for the fitting.}
}

\bold{Warning}: This function is an internal function and should not be used except for development purposes.
 Internal functions can be heavily modified and even renamed or removed in new version of the package.
}
\author{
David Strebler, University of Cologne (Germany).
}
\seealso{
\link{calc_TL.MAAD.fit.I},
\link{analyse_TL.MAAD}.
}

