\name{Gam2Hab}
\alias{Gam2Hab}
\title{
Extracting habitat use from GAM smoothing
}
\description{
The function smooth the original data using the \code{gam} function from the \pkg{mgcv} package (Generalized Additive Model with integrated smoothness estimation ) and then extract habitat use based on either one or two threshold(s).}
\usage{
Gam2Hab(mrt.x, mrt.y, data, IC = 0.95, Habitat1 = FALSE, Habitat2 = FALSE,
        strict = "FALSE", point = "TRUE", grid = "FALSE",
        ylab = "Elemental ratio")
}
\arguments{
  \item{mrt.x}{Column name for the chronological values to be used, typically the distance to the nucleus. Data in this colum must be numeric.}
  \item{mrt.y}{Column name for the elemental concentrations to be used. Data in this column must be numeric.}
  \item{data}{Dataframe to be analysed.}
  \item{IC}{Confidence interval for the fitted model. Default is 0.95.}
  \item{Habitat1}{
Threshold value to be used for discriminating between 2 habitats.
}
  \item{Habitat2}{
Threshold values to be used for discriminating between 2 habitats.
}
  \item{strict}{Indicates whether IC should be ignored for habitat attribution}
  \item{point}{Should the original data be plotted.}
  \item{grid}{Plot a background grid.}
  \item{ylab}{Legend to be used for the Y axis.}
}
\details{
\bold{Habitat} \cr The conventional approach often consists in qualitatively analyzing the trend of chemical concentrations and comparing this trend with threshold(s) established for discriminating between habitats. In this context, two thresholds can be used: one under which signal would typically be considered as residency in "habitat 1" (e.g. freshwater) and one over which signal would typically be considered as residency in "habitat 2" (e.g. marine). This is done using the \code{habitat2} argument. The presence of fish in one of the two provided habitats is establish according to the smooth fitted value +- 1SD generated by the GAM. If the fitted value - 1SD is higher than the highest threshold, measurement is attributed to one habitat. If the fitted value + 1SD is lower than the lowest threshold, measurement is attributed to the other habitat. Any intermediate value appearing between the two thresholds appears as "unassigned". Please, note that the two threshold values must be concatenated using the \code{c()} function,and preferably ordered increasingly. In case the user can't define two distinct thresholds, the functions also allow using one threshold value that separate two habitats using the \code{Habitat1} argument. When using either \code{Habitat1} or \code{Habitat2} argument, the associated threshold(s) are automatically plotted in the figure using dotted line(s).
\cr

\bold{Strict attribution} When the \code{strict} argument is turned \code{"TRUE"}, standard deviations from the GAM are ignored and fitted values are directly compared to threshold(s) value(s). 
}
\value{
A list including the following elements:
\item{Change}{Values of habitat change.}
\item{Habitat}{Dataframe containing habitat attribution for each original \code{mrt.x} value.}
        
}


\seealso{
\code{\link{mgcv}}
}
\examples{
data(univar)
# Using one threshold
Gam2Hab("Distance", "Sr:Ca", univar,Habitat1=3)
Gam2Hab("Distance", "Sr:Ca", univar,Habitat1=3,strict="TRUE")
# Using two thresholds
Gam2Hab("Distance", "Sr:Ca", univar,Habitat2=c(2,3))
Gam2Hab("Distance", "Sr:Ca", univar,Habitat2=c(2,3),strict="TRUE")
}

\keyword{GAM}
\keyword{univariate}
\keyword{habitat}