/**
* @file RcppExports.cpp
* @author Ghazaleh Haratinezhad Torbati and Glenn Lawyer
* @copyright Copyright (c) 2015 Max Planck Institute for Informatics and Ghazaleh 
* Haratinezhad Torbati and Glenn Lawyer All Rights Reserved.
* 
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2 of the License, or (at your
* option) any later version.
* 
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// This file was generated by Rcpp::compileAttributes
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393
#include <vector>
#include <string>
#include <Rcpp.h>
#include <ANN/ANN.h>

using namespace Rcpp;

int compute_TE(double& TE, std::vector<double>&X, std::vector<double>&Y,
		       int embedding,int k, std::string method, double epsDistance=-1, bool safetyChk = false);

RcppExport SEXP Rcpp_ComputeTE(SEXP Rx, SEXP Ry, SEXP Re, SEXP Rk, SEXP Rm, SEXP RepsDist, SEXP RsafetyCheck)
{
	List ret;
	double TE;
	NumericVector xx(clone(Rx));
	NumericVector yy(clone(Ry));
	std::vector<double> X(xx.begin(),xx.end());
	std::vector<double> Y(yy.begin(),yy.end());
	std::string method = as<std::string>(Rm);
	int embedding = as<int>(Re);
	int k = as<int>(Rk);
	double epsDist = as<double>(RepsDist);
	bool safetyCheck = as<bool> (RsafetyCheck);
	try{
		Rcpp::wrap(compute_TE(TE,X,Y,embedding,k,method,epsDist,safetyCheck));
	}
	catch(std::invalid_argument& e)
	{
		forward_exception_to_r(e);
	}
	ret["TE"] = TE;
	return(ret);
}
