% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synLFQ2.R
\docType{data}
\name{synLFQ2}
\alias{synLFQ2}
\title{Synthetic length frequency data II}
\format{A list consisting of:
\itemize{
  \item \strong{dates} dates of sampling times (class Date),
  \item \code{midLengths}: midpoints of the length classes,
  \item \code{Linf}: infinite length for investigated species in cm [cm],
  \item \code{K}: growth coefficent for investigated species per year [1/year],
  \item \code{catch}: matrix with catches/counts per length class (row) and sampling date (column).
}}
\source{
Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
   Part 1. Manual. FAO Fisheries Technical Paper, (306.1, Rev. 2). 407 p.
}
\usage{
data(synLFQ2)
}
\description{
Synthetic length frequency data from Sparre & Venema (1998). Can be used
   for the estimation of the instantaneous total mortality rate (Z) by means
   of \code{\link{Z_BevertonHolt}}.
}
\examples{
data(synLFQ2)
str(synLFQ2)
summary(synLFQ2)


}
\keyword{data}
\keyword{dataset}
\keyword{length-frequency}
