% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reml.R
\name{getIP.remlVCA}
\alias{getIP.remlVCA}
\title{Intermediate Precision for remlVCA-fitted objects of class 'VCA'}
\usage{
getIP.remlVCA(obj, vc)
}
\arguments{
\item{obj}{(object) of class 'VCA' fitted by 'remlVCA'}

\item{vc}{(character) string specifying the variance component
up to which an intermediate precision shall be derived}
}
\description{
Intermediate precision in this context here means any sum of variances
below the full model originally fitted. A typical use case could be 
reproducibility-experiments with a single lot or multiple lots, where
a pooled version of within-lab precision shall be determined.
}
\examples{
data(dataEP05A2_3)
res <- remlVCA(y~day/run, dataEP05A2_3)
IPday <- getIP.remlVCA(res, "day:run")
VCAinference(IPday)
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
