% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{transform_to_elogit}
\alias{transform_to_elogit}
\title{Transforms proportion looks to empirical logits.}
\usage{
transform_to_elogit(data = data, NoIA = NoIA,
  SamplesPerBin = SamplesPerBin, Constant = 0.5)
}
\arguments{
\item{data}{A data table object output by \code{\link{select_recorded_eye}}.}

\item{NoIA}{A positive integer indicating the number of interest areas defined 
when creating the study.}

\item{SamplesPerBin}{A positive integer indicating the number of samples in
each bin, which can be determines with \code{\link{check_samples_per_bin}}.}

\item{Constant}{A positive number used for the empirical logit and weights
calculation; by default, 0.5 as in Barr (2008).}
}
\value{
A data table with additional columns (the number of which depends on 
the number of interest areas specified) added to \code{data}.
}
\description{
\code{transform_to_elogit} transforms the proportion of looks for 
each interest area to empirical logits. Proportions are inherently bound 
between 0 and 1 and are therefore not suitable for some types of analysis. 
Logits provide an unbounded measure, though range from negative infinity to 
infinity, so it is important to know that this logit function adds a constant 
(hence, empirical logit). Additionally this calculates weights which estimate 
the variance in each bin (because the variance of the logit depends on the 
mean). This is important for regression analyses. N.B.: This function will 
work for data with a maximum of 8 interest areas.
}
\details{
These calculations are taken from:
Barr, D. J., (2008) Analyzing 'visual world' eyetracking data using 
multilevel logistic regression, \emph{Journal of Memory and Language}, 
\emph{59}(4), 457--474.
}
\examples{
\dontrun{
library(VWPre)
# Convert proportions to empirical logits and calculate weights...
df <- transform_to_elogit(dat, NoIA = 4, SamplesPerBin = 20, Constant = 0.5)
}
}

