\name{plot.warn}
\alias{plot.warn}
\title{
  Plot for posterior weaning parameters
}
\description{
  \code{plot.warn} is a plotting utile for quick visualization of the result of weaning age reconstruction from an object of class \code{"warn"}. The measured and modeled bone collagen nitrogen isotope ratios (d15Ns) are plotted ageinst estimated ages.
}
\usage{
\method{plot}{warn}(x, hline.female = TRUE, hline.adult = FALSE, 
  adult.mean = NA, adult.sd = 0,
  is.legend = TRUE, is.female = TRUE, \dots)
}
\arguments{
  \item{x}{an object of class \code{"warn"} generated by \code{\link{warn}}.}
  \item{hline.female, hline.adult}{logical; if \code{TRUE}, horizontal dotted lines indicating one standard deviation ranges of adult females and all adults are plotted on the figure; the default is \code{TRUE} for female and \code{FALSE} for adult.}
  \item{adult.mean}{the mean d15N of all adults, an optional single value.}
  \item{adult.sd}{the one standard deviation of all adult d15N, an optional single value. Utilized later in \code{\link{plot.warn}}.}
  \item{is.legend}{logical; if \code{TRUE} (the default), legend is plotted on the figure.}
  \item{is.female}{logical; if \code{TRUE} (the default), female mean d15N is plotted on the figure.}
  \item{\dots}{additional arguments passed to \code{\link{plot}}.}
}
\details{
  The following three results on d15N are plotted against age, the original measured ratios of non-adult bone collagen (Measured d15N), modeled ratios of non-adult bone collagen (Modeled d15N), and modeled ratios of collagen synthesized entirely from consumed foods in the last half year (Modeld diet). These results are calculated in \code{\link{warn}}. Mean d15Ns of adult females and all adults can also be plotted.
}
\references{
  Tsutaya, T., and Yoneda, M. (2013). Quantitative reconstruction of weaning ages in archaeological human populations using bone collagen nitrogen isotope ratios and approximate Bayesian computation. \emph{PLoS ONE} \bold{8}, e72327.
}
\seealso{
  \code{\link{WARN}}, \code{\link{warn}}, \code{\link{warnCI}}, \code{\link{warnProb}}, \code{\link{summary.warn}}
}
\examples{
## See ?warn for examples.
}
\keyword{math}
