% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xRWenricher.r
\name{xRWenricher}
\alias{xRWenricher}
\title{Function to perform connectivity enrichment analysis on the input graph}
\usage{
xRWenricher(data, g, Amatrix = NULL, num.permutation = 2000, nbin = 10,
steps = 4, chance = 2, seed = 825, verbose = TRUE)
}
\arguments{
\item{data}{a vector containing node names}

\item{g}{an object of class "igraph" or "graphNEL". It will be a
weighted graph if having an edge attribute 'weight'. The edge
directions are ignored for directed graphs}

\item{Amatrix}{an affinity matrix pre-computed from the input graph. It
is symmetric}

\item{num.permutation}{the number of permutations generating the null
distribution}

\item{nbin}{the number of bins dividing all nodes into the equal number
of nodes}

\item{steps}{an integer specifying the number of steps that random walk
performs. By default, it is 4}

\item{chance}{an integer specifying the chance of remaining at the same
vertex. By default, it is 2, the higher the higher chance}

\item{seed}{an integer specifying the seed}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
a data frame with 9 columns:
\itemize{
\item{\code{Obs}: the observed affinity between the given nodes}
\item{\code{Exp}: the expected affinity between the permuted nodes}
\item{\code{std}: the standard deviation of the expected}
\item{\code{fc}: fold change}
\item{\code{zscore}: z-score}
\item{\code{pvalue}: p-value}
\item{\code{or}: a vector containing odds ratio}
\item{\code{CIl}: a vector containing lower bound confidence interval
for the odds ratio}
\item{\code{CIu}: a vector containing upper bound confidence interval
for the odds ratio}
}
}
\description{
\code{xRWenricher} is supposed to perform connectivity enrichment
analysis on the input graph given a list of nodes of interest. The test
statistic is the average affinity between the given nodes. The pairwise
affinity between two nodes is estimated via short random walks. The
null distribution of the test statistic is generated by permuting node
labels on the graph (fixed) in a centrality-preserving manner. In
brief, all nodes are equally binned by centrality (defined as the mean
affinity to all other nodes), and a permuted instance is generated by
randomly sampling (a same number of) nodes from the same bin. The
connectivity ratio is the observed divided by the expected (the median
across the permutations), together with the empirical p-value.
}
\note{
The input graph will treat as an unweighted graph if there is no
'weight' edge attribute associated with. The edge direction is not
considered for the purpose of defining pairwise affinity; that is,
adjacency matrix and its laplacian version are both symmetric.
}
\examples{
# 1) generate a random graph according to the ER model
set.seed(825)
g <- erdos.renyi.game(10, 3/10)
V(g)$name <- paste0('n',1:vcount(g))

\dontrun{
# 2) perform connectivity enrichment analysis
data <- V(g)$name[1:3]
res <- xRWenricher(data, g, nbin=2)
}
}
\seealso{
\code{\link{xRWenricher}}
}
