% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichForest.r
\name{xEnrichForest}
\alias{xEnrichForest}
\title{Function to visualise enrichment results using a forest plot}
\usage{
xEnrichForest(eTerm, top_num = 10, FDR.cutoff = 0.05, CI.one = T,
colormap = "ggplot2.top", ncolors = 64, zlim = NULL,
barwidth = 0.5, barheight = NULL, wrap.width = NULL,
font.family = "sans", signature = FALSE, drop = F,
sortBy = c("or", "adjp", "fdr", "pvalue", "zscore", "fc", "nAnno",
"nOverlap", "none"))
}
\arguments{
\item{eTerm}{an object of class "eTerm" or "ls_eTerm". Alterntively, it
can be a data frame having all these columns (named as
'group','ontology','name','adjp','or','CIl','CIu')}

\item{top_num}{the number of the top terms (sorted according to OR).
For the eTerm object, if it is 'auto' (for eTerm), only the significant
terms (see below FDR.cutoff) will be displayed}

\item{FDR.cutoff}{FDR cutoff used to declare the significant terms. By
default, it is set to 0.05. Only works when top_num is 'auto' above}

\item{CI.one}{logical to indicate whether to allow the inclusion of one
in CI. By default, it is TURE (allowed)}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap), and
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta). Alternatively, any
hyphen-separated HTML color names, e.g. "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{ncolors}{the number of colors specified over the colormap}

\item{zlim}{the minimum and maximum z values for which colors should be
plotted, defaulting to the range of the -log10(FDR)}

\item{barwidth}{the width of the colorbar. Default value is
'legend.key.width' or 'legend.key.size' in 'theme' or theme}

\item{barheight}{the height of the colorbar. Default value is
'legend.key.height' or 'legend.key.size' in 'theme' or theme}

\item{wrap.width}{a positive integer specifying wrap width of name}

\item{font.family}{the font family for texts}

\item{signature}{logical to indicate whether the signature is assigned
to the plot caption. By default, it sets TRUE showing which function is
used to draw this graph}

\item{drop}{logical to indicate whether all factor levels not used in
the data will automatically be dropped. If FALSE (by default), all
factor levels will be shown, regardless of whether or not they appear
in the data}

\item{sortBy}{which statistics will be used for sorting and viewing
gene sets (terms). It can be "adjp" or "fdr" for adjusted p value
(FDR), "pvalue" for p value, "zscore" for enrichment z-score, "fc" for
enrichment fold change, "nAnno" for the number of sets (terms),
"nOverlap" for the number in overlaps, "or" for the odds ratio, and
"none" for ordering according to ID of terms. It only works when the
input is an eTerm object}
}
\value{
an object of class "ggplot"
}
\description{
\code{xEnrichForest} is supposed to visualise enrichment results using
a forest plot. A point is colored by the significance level, and a
horizontal line for the 95% confidence interval (CI) of odds ratio (OR;
the wider the CI, the less reliable). It returns an object of class
"ggplot".
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"

# provide the input Genes of interest (eg 100 randomly chosen human genes)
## load human genes
org.Hs.eg <- xRDataLoader(RData='org.Hs.eg',
RData.location=RData.location)
set.seed(825)
data <- as.character(sample(org.Hs.eg$gene_info$Symbol, 100))
data

# optionally, provide the test background (if not provided, all human genes)
#background <- as.character(org.Hs.eg$gene_info$Symbol)

# 1) Gene-based enrichment analysis using REACTOME pathways
# perform enrichment analysis
eTerm <- xEnricherGenes(data, ontology="REACTOME",
RData.location=RData.location)
## forest plot of enrichment results
gp <- xEnrichForest(eTerm, top_num="auto", FDR.cutoff=0.05)

# 2) Gene-based enrichment analysis using ontologies (REACTOME and GOMF)
# perform enrichment analysis
ls_eTerm <- xEnricherGenesAdv(data, ontologies=c("REACTOME","GOMF"),
RData.location=RData.location)
## forest plot of enrichment results
gp <- xEnrichForest(ls_eTerm, FDR.cutoff=0.1)
}
}
\seealso{
\code{\link{xEnricherGenes}}, \code{\link{xEnricherSNPs}},
\code{\link{xEnrichViewer}}
}
