% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ZINB}
\alias{ZINB}
\alias{dzinb}
\alias{pzinb}
\alias{qzinb}
\alias{rzinb}
\title{The Zero-Inflated Negative Binomial Distribution}
\usage{
dzinb(x, k, lambda, omega, log = FALSE)
pzinb(q, k, lambda, omega, lower.tail = TRUE, log.p = FALSE)
qzinb(p, k, lambda, omega, lower.tail = TRUE, log.p = FALSE)
rzinb(n, k, lambda, omega)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}

\item{k}{dispersion parameter.}

\item{lambda}{vector of (non-negative) means.}

\item{omega}{zero-inflation parameter.}

\item{log,log.p}{logical; if TRUE, probabilities \code{p} are given as \code{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \code{P[X <= x]}, otherwise, \code{P[X > x]}.}
}
\value{
\code{dzinb} gives the density, \code{pzinb} gives the distribution function,
\code{qzinb} gives the quantile function, and \code{rzinb} generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for the zero-inflated
negative binomial (ZINB) distribution with parameters \code{k}, \code{lambda}, and \code{omega}.
}
\examples{
dzinb(x = 0:10, k = 1, lambda = 1, omega = 0.5)
pzinb(q = c(1, 5, 9), k = 1, lambda = 1, omega = 0.5)
qzinb(p = c(0.25, 0.50, 0.75), k = 1, lambda = 1, omega = 0.5)
rzinb(n = 100, k = 1, lambda = 1, omega = 0.5)
}
\seealso{
\code{\link{dzip}}, \code{\link{pzip}}, \code{\link{qzip}}, and \code{\link{rzip}}
for the zero-inflated Poisson (ZIP) distribution.
}
\keyword{distribution}

