% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteTask.R
\name{deleteTask}
\alias{deleteTask}
\title{Delete Task}
\usage{
deleteTask(taskId = NULL, ...)
}
\arguments{
\item{taskId}{Required; ID of the task; String}

\item{\dots}{Additional arguments passed to \code{\link{abbyy_GET}}.}
}
\value{
Data frame with all the details of the task you are trying to delete: 
id (task id), registrationTime, statusChangeTime, status (Submitted, Queued, InProgress, 
Completed, ProcessingFailed, Deleted, NotEnoughCredits), filesCount (No. of files), credits, 
resultUrl (URL for the processed file if applicable)
}
\description{
Deletes task and associated data. While Abbyy says, "If you try to delete the task that has already been deleted, the successful response is returned," 
it doesn't appear to hold. Hence, the function now defaults to checking the status of the task via \code{\link{getTaskStatus}}, and 
deletes only if it hasn't been deleted. 
 
The function by default prints the status of the task you are trying to delete. It will show up as 'deleted' if successful.
}
\examples{
\dontrun{
deleteTask(taskId="task_id")
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/deleteTask/}
}
