% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propose.R
\name{add_an_admixture2}
\alias{add_an_admixture2}
\title{Adds a new admixture event to a graph.}
\usage{
add_an_admixture2(graph, admixture_variable_name, outgroup = "")
}
\arguments{
\item{graph}{An admixture graph.}

\item{admixture_variable_name}{A name for the new admixture proportion.}

\item{outgroup}{An optional parameter for the preferred outgroup.}
}
\value{
A list of graphs made by adding a new admixture event to the input graph. The list contains
        duplicate elements, and may even contain graphs with \emph{eyes} (two inner nodes with the
        property that all the paths between any two leaves visits both or neither of them).
}
\description{
Given an admixture graph, selects a child edge and two parent edges, disconnects the child edge
from its original parent node and connects it to the two parent edges with an admixture event,
if possible. Thus, contrary to \code{\link{add_an_admixture}}, the resulting graph need not be an
extension of the input graph in the sense that erasing one of the admixture edges we get
the original admixture graph. In practice, we know that when fitting data to admixture graphs,
the best graph with \eqn{k} admixture events is not always an extension like that from the best
graph with \eqn{k - 1} admixture events. Most likely it doesn't need to be an extension like
this (the two new admixture edges can both go where ever) either.
}
\seealso{
\code{\link{make_permutations}}

\code{\link{four_leaves_graphs}}

\code{\link{five_leaves_graphs}}

\code{\link{six_leaves_graphs}}

\code{\link{seven_leaves_trees}}

\code{\link{eight_leaves_trees}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{make_an_outgroup}}
}

