\name{kempton.slatehall}
\alias{kempton.slatehall}
\docType{data}
\title{
  Slate Hall Farm 1976 spring wheat
}
\description{
  Yields for a trial at Slate Hall Farm in 1976.
}

\format{
  A data frame with 150 observations on the following 5 variables.
  \describe{
    \item{\code{rep}}{Rep factor, 6 levels}
    \item{\code{row}}{Row}
    \item{\code{col}}{Column}
    \item{\code{gen}}{Genotype factor, 25 levels}
    \item{\code{yield}}{Yield (grams/plot)}
  }
}
\details{
  The trial was a balanced lattice with 25 varieties in 6 replicates,
  10 ranges of 15 columns.  The plot size was 1.5 meters by 4 meters.
  Each row within a rep is an (incomplete) block.
}
\source{
  R A Kempton and P N Fox. (1997).
  \emph{Statistical Methods for Plant Variety Evaluation},
  Chapman and Hall.   Page 84.
}
\references{
  Gilmour, Arthur R and Robin Thompson and Brian R Cullis. (1994).
  Average Information REML: An Efficient Algorithm for Variance
  Parameter Estimation in Linear Mixed Models, \emph{Biometrics},
  51, 1440-1450.
}
\examples{

dat <- kempton.slatehall
dat <- transform(dat, xf=factor(col), yf=factor(row))

desplot(yield ~ col * row, dat, num=gen, out1=rep,
        main="kempton.slatehall")

# Incomplete block model of Gilmour et al 1995
if(require(lme4)){
m1 <- lmer(yield ~ gen + (1|rep) + (1|rep:yf) + (1|rep:xf), data=dat)

vc(m1)
##    groups        name variance stddev
##  rep:xf   (Intercept)    14810 121.7
##  rep:yf   (Intercept)    15600 124.9
##  rep      (Intercept)     4262  65.29
##  Residual                 8062  89.79

}

\dontrun{
# Incomplete block model of Gilmour et al 1995
require("asreml")
m2 <- asreml(yield ~ gen, random = ~ rep/(xf+yf), data=dat)

vc(m2)
##          effect component std.error z.ratio constr
##     rep!rep.var      4262      6890    0.62    pos
##  rep:xf!rep.var     14810      4865    3       pos
##  rep:yf!rep.var     15600      5091    3.1     pos
##      R!variance      8062      1340    6       pos

# Table 4
predict(m2, classify="gen")$predictions$pvals

}
}
\keyword{datasets}
