% Generated by roxygen2 (4.0.1): do not edit by hand
\name{markov}
\alias{markov}
\title{Compute a Markov Basis with 4ti2}
\usage{
markov(mat, format = c("mat", "vec", "tab"), dim = NULL, all = FALSE,
  dir = tempdir(), opts = "-parb", quiet = TRUE, dbName)
}
\arguments{
\item{mat}{a matrix; for example the output of hmat}

\item{format}{how the moves should be returned (if "mat", moves are columns)}

\item{dim}{the dimension to be used in vec2tab if format = "tab" is used, oftentimes a vector of the number of levels of each variable in order}

\item{all}{if TRUE, all moves (+ and -) are given.  if FALSE, only the + moves are given.}

\item{dir}{directory to place the files in, without an ending /}

\item{opts}{options for markov}

\item{quiet}{show 4ti2 output}

\item{dbName}{the name of the model in the markov bases database, http://markov-bases.de, see examples}
}
\value{
a matrix containing the Markov basis as its columns (for easy addition to tables)
}
\description{
A Markov basis of a matrix A is computed with the markov function of 4ti2, obtained with the LattE-integrale bundle.
}
\examples{
\dontrun{




# 2x2 independence example
# following convention, the first index indicates rows
varlvls <- c(2,2)
facets <- list(1,2)
( A <- hmat(varlvls, facets) )
markov(A)
markov(A, "vec")
markov(A, "tab", varlvls)
markov(A, "tab", varlvls, TRUE)




# 3x3 independence example
# following convention, the first index indicates rows
varlvls <- c(3,3)
facets <- list(1,2)
( A <- hmat(varlvls, facets) )
markov(A)
markov(A, "vec")
markov(A, "tab", varlvls)
markov(A, "tab", varlvls, TRUE)




# LAS example 1.2.1, p.12 (2x3 independence)
varlvls <- c(2,3)
facets <- list(1, 2)
( A <- hmat(varlvls, facets) )
markov(A, "tab", varlvls)
# Prop 1.2.2 says that there should be
2*choose(2, 2)*choose(3,2) # = 6
# moves.
markov(A, "tab", varlvls, TRUE)





# LAS example 1.2.12, p.17  (no 3-way interaction)
varlvls <- c(2,2,2)
facets <- list(c(1,2), c(1,3), c(2,3))
( A <- hmat(varlvls, facets) )
markov(A)






# LAS example 1.2.12, p.16  (no 3-way interaction)
varlvls <- c(2,2,2,2)
facets <- list(c(1,2), c(1,4), c(2,3))
( A <- hmat(varlvls, facets) )
markov(A)
markov(A, "tab", varlvls) # hard to understand
tableau(markov(A), varlvls)










# using the markov bases database, must be connected to internet
# A <- markov(dbName = "ind3-3")
B <- markov(hmat(c(3,3), list(1,2)))
# all(A == B)












markov(diag(1, 10))

}
}
\references{
Drton, M., B. Sturmfels, and S. Sullivant (2009). \emph{Lectures on Algebraic Statistics}, Basel: Birkhauser Verlag AG.
}

