% Generated by roxygen2 (4.0.1): do not edit by hand
\name{vec2tab}
\alias{vec2tab}
\title{Vector to Array conversion}
\usage{
vec2tab(vec, dim)
}
\arguments{
\item{vec}{a vector}

\item{dim}{the desired array dimensions, oftentimes a vector of the number of levels of each variable in order}
}
\value{
an array
}
\description{
Convert a vector into an array given a set of dimensions; it therefore simply wraps \code{aperm} and \code{array}.
}
\details{
This function converts an array (or a multi-way contingency table) into a vector, using a consistent ordering of the cells.  The ordering of the cells is lexicographical and cannot be specified by the user.
}
\examples{
data(Titanic)
Titanic
tab2vec(Titanic)
vec2tab(tab2vec(Titanic), dim(Titanic))
vec2tab(tab2vec(Titanic), dim(Titanic)) == Titanic
all(vec2tab(tab2vec(Titanic), dim(Titanic)) == Titanic)
}
\seealso{
\code{\link{tab2vec}}, \code{\link{aperm}}, \code{\link{array}}
}

