% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/droplet-ssh.R
\name{droplet_ssh}
\alias{droplet_ssh}
\alias{droplet_upload}
\alias{droplet_download}
\title{Remotely execute ssh code, upload & download files.}
\usage{
droplet_ssh(droplet, ..., user = "root", keyfile = NULL,
  ssh_passwd = NULL, verbose = FALSE)

droplet_upload(droplet, local, remote, user = "root", keyfile = NULL,
  ssh_passwd = NULL, verbose = FALSE)

droplet_download(droplet, remote, local, user = "root", keyfile = NULL,
  ssh_passwd = NULL, verbose = FALSE, overwrite = FALSE)
}
\arguments{
\item{droplet}{A droplet, or something that can be coerced to a droplet by
\code{\link{as.droplet}}.}

\item{...}{Shell commands to run. Multiple commands are combined with
\code{&&} so that execution will halt after the first failure.}

\item{user}{User name. Defaults to "root".}

\item{keyfile}{Optional private key file.}

\item{ssh_passwd}{Optional passphrase or callback function for authentication.
Refer to the \code{ssh::ssh_connect} documentation for more
details.}

\item{verbose}{If TRUE, will print command before executing it.}

\item{local, remote}{Local and remote paths.}

\item{overwrite}{If TRUE, then overwrite destination files if they already
exist.}
}
\value{
On success, the droplet (invisibly). On failure, throws an error.
}
\description{
Assumes that you have ssh & scp installed, and password-less login set up on
the droplet.
}
\details{
Uploads and downloads are recursive, so if you specify a directory,
everything inside the directory will also be downloaded.

With the chang to package \code{ssh}, we create ssh session objects
(C pointers) internally, and cache them, then look them up in the cache
based on combination of user and IP address. That is, there's separate
sessions for each user for the same IP address.

ssh sessions are cleaned up at the end of your R session.
}
\examples{
\dontrun{
d <- droplet_create() \%>\% droplet_wait()

# Upgrade system packages
d \%>\%
  droplet_ssh("apt-get update") \%>\%
  droplet_ssh("sudo apt-get upgrade -y --force-yes") \%>\%
  droplet_ssh("apt-get autoremove -y")

# Install R
d \%>\%
  droplet_ssh("apt-get install r-base-core r-base-dev --yes --force-yes")

# Upload and download files -------------------------------------------------

tmp <- tempfile()
saveRDS(mtcars, tmp)
d \%>\% droplet_upload(tmp, ".")
d \%>\% droplet_ssh("ls")

tmp2 <- tempdir()
d \%>\% droplet_download(basename(tmp), tmp2)
mtcars2 <- readRDS(file.path(tmp2, basename(tmp)))

stopifnot(all.equal(mtcars, mtcars2))


## another upload/download example
tmp <- tempfile(fileext = ".txt")
writeLines("foo bar", tmp)
readLines(tmp)
d \%>\% droplet_upload(tmp, ".")
d \%>\% droplet_ssh("ls")

tmp2 <- tempdir()
unlink(tmp)
d \%>\% droplet_download(basename(tmp), tmp2)
readLines(file.path(tmp2, basename(tmp)))
}
}
