% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docklets_create.R
\name{docklets_create}
\alias{docklets_create}
\title{Docklets: docker on droplets - create many docklets}
\usage{
docklets_create(
  names = NULL,
  size = getOption("do_size", "s-1vcpu-2gb"),
  region = getOption("do_region", "sfo3"),
  ssh_keys = getOption("do_ssh_keys", NULL),
  backups = getOption("do_backups", NULL),
  ipv6 = getOption("do_ipv6", NULL),
  private_networking = getOption("do_private_networking", NULL),
  tags = list(),
  wait = TRUE,
  image = "docker-18-04",
  ...
)
}
\arguments{
\item{names}{(character) Names of the droplets. The human-readable string
you wish to use when displaying the Droplet name. The name, if set to
a domain name managed in the DigitalOcean DNS management system, will
configure a PTR record for the Droplet. The name set during creation will
also determine the hostname for the Droplet in its internal configuration.
Default: picks a random name from \code{\link{words}} if none supplied.}

\item{size}{(character) Size slug identifier. See \code{\link{sizes}()} for
a complete list. Default: s-1vcpu-1gb, the smallest}

\item{region}{(character) The unique slug identifier for the region that you
wish to deploy in. See \code{\link{regions}()} for a complete list.
Default: sfo3}

\item{ssh_keys}{(character) A character vector of key names, an integer
vector of key ids, or NULL, to use all keys in your account. Accounts
with the corresponding private key will be able to log in to the droplet.
See \code{\link{keys}()} for a list of the keys that you've added.
Default: NULL}

\item{backups}{(logical) Enable backups. A boolean indicating whether
automated backups should be enabled for the droplet. Automated backups can
only be enabled when the droplet is created, and cost extra.
Default: FALSE}

\item{ipv6}{(logical) A boolean indicating whether IPv6 is enabled on the
droplet.}

\item{private_networking}{(logical) Use private networking. Private
networking is currently only available in certain regions.
Default: \code{FALSE}}

\item{tags}{(character) A vector of tag names to apply to the Droplet after
it is created. Tag names can either be existing or new tags.
Default: list()}

\item{wait}{If \code{TRUE} (default), wait until droplet has been
initialised and is ready for use. If set to \code{FALSE} we return a
droplet object right away after droplet creation request has been sent.
Note that there won't be an IP address in the object yet. Note that
waiting means we ping the DigitalOcean API to check on the status of your
droplet, which uses up your API requests. The option \code{do.wait_time}
can be set to any positive integer to determine how many seconds between
pings. The default is 1 sec. Note that if you are creating droplets in a
loop, parallel or otherwise, set \code{do.wait_time} within the loop
instead of outside of it.}

\item{image}{(character/numeric) The image ID of a public or private image,
or the unique slug identifier for a public image. This image will be the
base image for your droplet. See \code{\link{images}()} for a complete
list. Default: ubuntu-18-04-x64}

\item{...}{Additional options passed down to \code{\link[httr]{POST}}}
}
\value{
Two or more droplet objects
}
\description{
Docklets: docker on droplets - create many docklets
}
\section{Missing droplet ID}{

If you get a droplet object back without an IP address, the IP
address was not assigned when the payload was returned by DigitalOcean.
Simply run \code{d <- droplet(d$id)} to update your droplet object and the IP
address will populate.
}

\examples{
\dontrun{
# if no names given, creates two droplets with random names
docklets_create()

# give names
docklets_create(names = c('drop1', 'drop2'))
docklets_create(names = c('drop3', 'drop4'))
}
}
