% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{getAnametrixDataset}
\alias{getAnametrixDataset}
\title{getAnametrixDataset}
\usage{
getAnametrixDataset(table.object, segment.id = NULL, columns = NULL,
  filter.def = list(column = NULL, type = c("equals", "in this list"), value =
  NULL), start.date, end.date, max.rows = 1e+08, unit.of.time = "day",
  sort.column = NULL, sort.direction = "asc", verbose = TRUE,
  date.format.override = FALSE, return.as.date.selection = FALSE,
  use.binary.func = TRUE)
}
\arguments{
\item{table.object}{Configuration of a table. Use  \code{\link{getTableConfiguration}} to get it}

\item{segment.id}{segment id to apply (see \code{\link{getSegmentInfo}}). NULL is no segment is wanted.}

\item{columns}{Array of column names for the request. Example: c("city","country","male_population")
Use \code{printTable(tableObject)} to see all column names (internal names are used) or the field $ColumnNames of the output of \code{\link{getTableConfiguration}}
If columns is an empty vector, all the columns of the table will be downloaded.}

\item{filter.def}{equal or in this list filter. Needs to be of the form \code{filter.def = list(column=NULL, type=c("equals", "in this list"), value=NULL)}}

\item{start.date}{Start date of the request. Use YYYY-MM-DD format. Example: "2015-01-01"}

\item{end.date}{End date of the request. Use YYYY-MM-DD format. Example: "2016-01-01"}

\item{max.rows}{Number of rows requested. Example: 10000}

\item{unit.of.time}{Format of the date column. Example: "day", "hour", "week", or custom format like "MM-dd-yy" or "w-yyyy"}

\item{sort.column}{Column to sort on. Use any column provided in the columns array}

\item{sort.direction}{"desc" or "asc"}

\item{verbose}{Specifies whether to print out notifications}

\item{date.format.override}{TRUE or FALSE. Adjusts date formatting}

\item{return.as.date.selection}{NULL, TRUE or FALSE. Adjusts date formatting}

\item{use.binary.func}{TRUE or FALSE}
}
\value{
R data frame containing the number of observations requested from the Anametrix API table
}
\description{
Extracts data from Anametrix API into an R data frame
}
\details{
if \code{use.binary.func} is FALSE, getURL is used to download text to a temporary file that is read in a dataframe
if \code{use.binary.func} is TRUE, getBinaryURL is used to download binary data. This can be used to avoid error in encoding like embedded null. No temporary file is used.
}
\seealso{
Other dowload/upload functions: \code{\link{getAxDatasetFromEncodedQuery}},
  \code{\link{getTableConfiguration}},
  \code{\link{uploadData}}
}

