% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apaCorrelationTable.R
\name{apa.cor.table}
\alias{apa.cor.table}
\title{Creates a correlation table in APA style with means and standard deviations}
\usage{
apa.cor.table(data, filename = NA, table.number = NA,
  show.conf.interval = TRUE, landscape = TRUE)
}
\arguments{
\item{data}{Project data frame}

\item{filename}{(optional) Output filename document filename (must end in .rtf or .doc only)}

\item{table.number}{Integer to use in table number output line}

\item{show.conf.interval}{(TRUE/FALSE) Display confidence intervals in table.}

\item{landscape}{(TRUE/FALSE) Make RTF file landscape}
}
\value{
APA table object
}
\description{
Creates a correlation table in APA style with means and standard deviations
}
\examples{
# View top few rows of attitude data set
head(attitude)

# Use apa.cor.table function
apa.cor.table(attitude)
apa.cor.table(attitude, show.conf.interval=FALSE)
apa.cor.table(attitude, filename="ex.CorTable1.doc")
apa.cor.table(attitude, show.conf.interval=FALSE, filename="ex.CorTable2.doc")
}

