% Generated by roxygen2 (4.0.1): do not edit by hand
\name{example_apsim}
\alias{example_apsim}
\title{Access example APSIM simulations}
\usage{
example_apsim(path, wd = getwd(), files = NULL, ...)
}
\arguments{
\item{path}{path to the APSIM installation}

\item{wd}{working directory containing the .apsim files to be copied; defaults to the current working directory}

\item{files}{files to extract from the "Examples" folder}

\item{...}{additional arguments passed to \code{\link[base:file.copy]{file.copy}}}
}
\value{
logical; if \code{TRUE} the corresponding file was successfully copied, \code{FALSE} otherwise
}
\description{
There are quite a few standard APSIM simulations provided in the default APSIM installation.
\code{apsim_expample} moves those example files into the working directory \code{wd} so you can run them
or edit them using \code{\link{apsim}} and \code{\link{edit_apsim}}, respectively.  Generally the
example simulations must be moved because the output file is written to the directory containing
the .apsim file and the ability to write in the "Program Files" folder is limited in most cases.
}
\examples{
\dontrun{
path <-"C:/Program Files (x86)/Apsim76-r3376/"
wd <- "~/APSIM"
file <- "Canopy.apsim"
example_apsim(path = path, wd = wd, file) #TRUE

file <- c("Canopy.apsim", "Continuous Wheat.apsim")
example_apsim(path = path, wd = wd, file) #TRUE TRUE

exe <-"C:/Program Files (x86)/Apsim76-r3376/Model/Apsim.exe"
results <- apsim(exe, wd, files = file)
}
}

