% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repairMissingHzDepths.R
\name{repairMissingHzDepths}
\alias{repairMissingHzDepths}
\title{Repair Problematic Lower Horizon Depths}
\usage{
repairMissingHzDepths(x, adj = 10)
}
\arguments{
\item{x}{\code{SoilProfileCollection}}

\item{adj}{vertical offset applied to "repair" affected bottom depths}
}
\value{
\code{SoilProfileCollection} with a new (logical) horizon-level attribute \code{.repaired} marking affected horizons
}
\description{
Attempt a simple repair of horizon bottom depths in the presence of \code{NA}, or in cases where the horizon shares a common top and bottom depth. Both situations are common in pedon description where "contact" (Cd, Cr, R, etc.) was described without a lower depth. This repair is only applied to the deepest horizon within a profile as identified by \code{\link{getLastHorizonID}}.
}
