% Generated by roxygen2 (4.0.0): do not edit by hand
\name{tarLocalRepo}
\alias{tarGithubRepo}
\alias{tarLocalRepo}
\title{Create a Tar Archive From an Existing Repository}
\usage{
tarLocalRepo(repoDir)

tarGithubRepo(repoTo, user, repo, branch = "master", repoDirGit = FALSE)
}
\arguments{
  \item{repoDir}{A character that specifies the directory
  of the Repository which will be tarred.}

  \item{repo}{Only if working with a Github repository. A
  character containing a name of a Github repository on
  which the Repository to be tarred is archived.}

  \item{user}{Only if working with a Github repository. A
  character containing a name of a Github user on whose
  account the \code{repo} is created.}

  \item{branch}{Only if working with a Github repository. A
  character containing a name of Github repository's branch
  in which Repository to be tarred is archived. Default
  \code{branch} is \code{master}.}

  \item{repoDirGit}{Only if working with a Github
  repository. A character containing a name of a directory
  on Github repository on which the Repository to be tarred
  is stored. If the Repository is stored in main folder on
  Github repository, this should be set to \code{repoDirGit
  = FALSE} as default.}

  \item{repoTo}{Only if working with a Github repository. A
  characterthat specifies the directory in which will be
  created tar archive from \code{Repository} stored on
  Github.}
}
\description{
\code{tarLocalRepo} and \code{tarGithubRepo} create a tar
archive from an existing \link{Repository}.
}
\details{
\code{tarLocalRepo} and \code{tarGithubRepo} create a tar
archive from an existing \link{Repository}.
\code{tarLocalRepo} tars local \code{Repository},
\code{tarGithubRepo} tars \code{Repository} stored on
Github.
}
\examples{
# objects preparation
\dontrun{
# data.frame object
data(iris)

# ggplot/gg object
library(ggplot2)
df <- data.frame(gp = factor(rep(letters[1:3], each = 10)),y = rnorm(30))
library(plyr)
ds <- ddply(df, .(gp), summarise, mean = mean(y), sd = sd(y))
myplot123 <- ggplot(df, aes(x = gp, y = y)) +
  geom_point() +  geom_point(data = ds, aes(y = mean),
               colour = 'red', size = 3)

# lm object
model <- lm(Sepal.Length~ Sepal.Width + Petal.Length + Petal.Width, data= iris)

# Local version

exampleRepoDir <- tempdir()
createEmptyRepo( repoDir = exampleRepoDir )
saveToRepo( myplot123, repoDir=exampleRepoDir )
saveToRepo( iris, repoDir=exampleRepoDir )
saveToRepo( model, repoDir=exampleRepoDir )

tarLocalRepo( exampleRepoDir )

deleteRepo( exampleRepoDir )

rm( exampleRepoDir )

# Github version

tarGithubRepo( user="MarcinKosinski",
repo="Museum", branch="master", repoDirGit="ex1" )

tarGithubRepo( user="pbiecek, repo="archivist, repoTo = getwd( ) )

}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
\code{\link{Tags}}; \code{\link{archivist-package}};
\code{\link{copyGithubRepo}}, \code{\link{copyLocalRepo}};
\code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
\code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
\code{\link{loadFromGithubRepo}},
\code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
\code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
\code{\link{searchInGithubRepo}},
\code{\link{searchInLocalRepo}};
\code{\link{showGithubRepo}}, \code{\link{showLocalRepo}};
\code{\link{summaryGithubRepo}},
\code{\link{summaryLocalRepo}}

Other archivist: \code{\link{Repository}};
\code{\link{Tags}}; \code{\link{archivist-package}};
\code{\link{copyGithubRepo}}, \code{\link{copyLocalRepo}};
\code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
\code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
\code{\link{loadFromGithubRepo}},
\code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
\code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
\code{\link{searchInGithubRepo}},
\code{\link{searchInLocalRepo}};
\code{\link{showGithubRepo}}, \code{\link{showLocalRepo}};
\code{\link{summaryGithubRepo}},
\code{\link{summaryLocalRepo}}
}

