% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveToRepo.R
\name{saveToLocalRepo}
\alias{saveToLocalRepo}
\alias{saveToRepo}
\alias{asave}
\title{Save an Artifact into a Repository}
\usage{
saveToLocalRepo(artifact, repoDir = aoptions("repoDir"),
  archiveData = TRUE, archiveTags = TRUE, archiveMiniature = TRUE,
  archiveSessionInfo = TRUE, force = TRUE, value = FALSE, ...,
  userTags = c(), use_flocks = aoptions("use_flocks"),
  silent = aoptions("silent"), ascii = FALSE,
  artifactName = deparse(substitute(artifact)))

saveToRepo(artifact, repoDir = aoptions("repoDir"), archiveData = TRUE,
  archiveTags = TRUE, archiveMiniature = TRUE,
  archiveSessionInfo = TRUE, force = TRUE, value = FALSE, ...,
  userTags = c(), use_flocks = aoptions("use_flocks"),
  silent = aoptions("silent"), ascii = FALSE,
  artifactName = deparse(substitute(artifact)))

asave(artifact, repoDir = aoptions("repoDir"), archiveData = TRUE,
  archiveTags = TRUE, archiveMiniature = TRUE,
  archiveSessionInfo = TRUE, force = TRUE, value = FALSE, ...,
  userTags = c(), use_flocks = aoptions("use_flocks"),
  silent = aoptions("silent"), ascii = FALSE,
  artifactName = deparse(substitute(artifact)))
}
\arguments{
\item{artifact}{An arbitrary R artifact to be saved. For supported artifacts see details.}

\item{repoDir}{A character denoting an existing directory in which an artifact will be saved.}

\item{archiveData}{A logical value denoting whether to archive the data from the \code{artifact}.}

\item{archiveTags}{A logical value denoting whether to archive Tags from the \code{artifact}.}

\item{archiveMiniature}{A logical value denoting whether to archive a miniature of the \code{artifact}.}

\item{archiveSessionInfo}{A logical value denoting whether to archive the session info that describes the context in this given artifact was created.}

\item{force}{A logical value denoting whether to archive \code{artifact} if it was already archived in
a Repository.}

\item{value}{A logical value. Should the result be (default \code{value = FALSE}) the \code{md5hash}
of a stored artifact or should the result be an input artifact (\code{value = TRUE}), so that valueing code
can be used. See examples.}

\item{...}{Graphical parameters denoting width and height of a miniature. See details.
Further arguments passed to \link{head}. See Details section about \code{firtsRows} parameter}

\item{userTags}{A character vector with Tags. These Tags will be added to the repository along with the artifact.}

\item{use_flocks}{A logical value. If \code{TRUE} then \code{flock} package is used to lock access to a database. By default it's \code{FALSE}.}

\item{silent}{If TRUE produces no warnings.}

\item{ascii}{A logical value. An \code{ascii} argument is passed to \link{save} function.}

\item{artifactName}{The name of the artifact with which it should be archived. If \code{NULL} then object's MD5 hash will be used instead.}
}
\value{
As a result of calling this function a character string is returned, which determines
the \code{md5hash} of the artifact. If
\code{archiveData} is \code{TRUE}, the result will also
have an attribute, named \code{data}, which determines \code{md5hash} of the data needed
to compute the artifact.
}
\description{
\code{saveToLocalRepo} function saves desired artifacts to the local \link{Repository} in a given directory.
To learn more about artifacts visit \link[archivist]{archivist-package}.
}
\details{
\code{saveToLocalRepo} function saves desired artifacts to the local Repository in a given directory.
Artifacts are saved in the local Repository, which is a SQLite database named \code{backpack}.
After every \code{saveToLocalRepo} call the database is refreshed, so the artifact is available
immediately in the database for other collaborators.
Each artifact is archived in a \code{md5hash.rda} file. This file will be saved in a folder
(under \code{repoDir} directory) named \code{gallery}. For each artifact, \code{md5hash} is a
unique string of length 32 that is produced by
\link[digest]{digest} function, which uses a cryptographical MD5 hash algorithm.

By default, a miniature of an artifact and (if possible) a data set needed to compute this artifact are extracted.
They are also going to be saved in a file named by their \code{md5hash} in the \code{gallery} folder
that exists in the directory specified in the \code{repoDir} argument. Moreover, a specific \code{Tag}-relation
is going to be added to the \code{backpack} dataset in case there is a need to load
the artifact with it's related data set - see \link{loadFromLocalRepo} or \link{loadFromRemoteRepo}. Default settings
may be changed by using the \code{archiveData}, \code{archiveTag} or \code{archiveMiniature} arguments with the
\code{FALSE} value.

\code{Tags} are artifact's attributes, different for various artifact's classes. For more detailed
information check \link{Tags}

Archived artifact can be searched in the \code{backpack} dataset by using the
\link{searchInLocalRepo} or \link{searchInRemoteRepo} functions. Artifacts can be searched by their \link{Tags},
\code{names}, \code{classes} or \code{archiving date}.

\code{firstRows} parameter.

If the artifact is of class \code{data.frame} or user set \code{archiveData = TRUE} for artifact that stores data within it,
 it is possible to specify
how many rows of that data (or that \code{data.frame}) should be archived in a \code{miniature}.
 This can be done by adding the argument \code{firstRows} with the
n corresponding to the number of rows (as in \link{head}).
Note that, the data can be extracted only from the artifacts that are supported by
the \pkg{archivist} package; see \link{Tags}.

Graphical parameters.

If the artifact is of class \code{lattice} or \code{ggplot}, and
\code{archiveMiniature = TRUE}, then it is
possible to set the miniature's \code{width} and \code{height} parameters. By default they are set to
\code{width = 800}, \code{height = 600}.

Supported artifact's classes are listed here \link{Tags}.
}
\note{
In the following way one can specify his own \code{Tags} for artifacts by setting artifact's attribute
before call of the \code{saveToLocalRepo} function:
\code{attr(x, "tags" ) = c( "name1", "name2" )}, where \code{x} is an artifact
and \code{name1, name2} are \code{Tags} specified by a user.
It can be also done in a new, simpler way by using \code{userTags} parameter like this:
 \itemize{
   \item \code{saveToLocalRepo(model, repoDir, userTags = c("my_model", "do not delete"))}.
 }
 
Specifing additional \code{Tags} by attributes can be beneficial when one uses \link{addHooksToPrint}.
 

Important: if one wants to archive data from artifacts which is one of:
\code{survfit, glmnet, qda, lda, trellis, htest} class, and this dataset is transformed within
the artifact's formula then \code{saveToLocalRepo} will not archive this dataset. \code{saveToLocalRepo}
only archives datasets that already exist in any of R environments.

Example: The data set will not be archived here.
\itemize{
   \item \code{z <- lda(Sp ~ ., Iris, prior = c(1,1,1)/3, subset = train[,-8])}
   \item \code{saveToLocalRepo( z, repoDir )}
}
Example: The data set will be archived here.
\itemize{
   \item \code{train2 <- train[,-8]}
   \item \code{z <- lda(Sp ~ ., Iris, prior = c(1,1,1)/3, subset = train2)}
   \item \code{saveToLocalRepo( z, repoDir )}
}
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
\dontrun{
exampleRepoDir <- tempfile(tmpdir = ".")
createLocalRepo(repoDir = exampleRepoDir)
data(swiss)
saveToLocalRepo(swiss, repoDir=exampleRepoDir, archiveSessionInfo = TRUE)
showLocalRepo(method = "md5hashes", repoDir = exampleRepoDir)
showLocalRepo(method = "tags", repoDir = exampleRepoDir)

loadFromLocalRepo(md5hash = '2a6e492cb6982f230e48cf46023e2e4f',
  repoDir = system.file("graphGallery", package = "archivist"), value = TRUE) -> model

saveToLocalRepo(model, repoDir=exampleRepoDir,
             userTags = c("do not delete", "my favourite model"))
aoptions('repoDir', system.file("graphGallery", package = "archivist"))
showLocalRepo(method = "tags")
data(iris)
asave(iris, silent = FALSE) # iris was used in pl
aoptions('repoDir', NULL, unset = TRUE)
deleteLocalRepo(exampleRepoDir, TRUE)
rm(exampleRepoDir)
}

}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
For more detailed information check the \pkg{archivist} package
\href{http://pbiecek.github.io/archivist/}{Use Cases}.
The list of supported artifacts and their tags is available on \code{wiki} on \pkg{archivist}
\href{https://github.com/pbiecek/archivist/wiki/archivist-package---Tags}{Github Repository}.

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}
\author{
Marcin Kosinski , \email{m.p.kosinski@gmail.com}
}
\concept{archivist}
