% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/3_ComplexModels.R
\name{M_M_INF}
\alias{M_M_INF}
\title{Obtains the main characteristics of a M/M/\eqn{\infty} queueing model}
\usage{
M_M_INF(lambda = 3, mu = 6)
}
\arguments{
\item{lambda}{Mean arrival rate}

\item{mu}{Mean service rate}
}
\value{
Returns the next information of a M/M/\eqn{\infty} model:
\item{rho}{Constant coefficient: \eqn{\lambda/\mu}}
\item{barrho}{Traffic intensity: \ifelse{latex}{\eqn{\bar{\rho}}}{\out{<i>&#862;&rho;</i>}}}
\item{p0}{Probability of empty system: \ifelse{latex}{\eqn{P_{0}}}{\out{<i>P<sub>0</sub></i>}}}
\item{l}{Number of customers in the system: \eqn{L}}
\item{lq}{Number of customers in the queue: \ifelse{latex}{\eqn{L_q} (\eqn{L_q} = 0 in this model)}{\out{<i>L<sub>q</sub> (L<sub>q</sub> = 0 in this model)</i>}}}
\item{w}{Waiting time in the system: \eqn{W}}
\item{wq}{Waiting time in the queue: \ifelse{latex}{\eqn{W_q} (\eqn{W_q} = 0 in this model)}{\out{<i>W<sub>q</sub> (W<sub>q</sub> = 0 in this model)</i>}}}
\item{eff}{System efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_q)}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
}
\description{
Obtains the main characteristics of a M/M/\eqn{\infty} queueing model
}
\examples{
#The number of people turning on their television sets
#on Saturday evening during prime time can be described
#rather well by a Poisson distribution with a mean of
#100000/hr.
#There are five major TV stations, and a given person
#chooses among them essentially at random.
#Surveys have also shown that the average person tunes
#in for 90 min and that viewing times are approximately
#exponentially distributed.
M_M_INF(lambda=100000/5, mu=60/90)
}
\seealso{
Other AnaliticalModels: \code{\link{ClosedJacksonNetwork}};
  \code{\link{M_M_1_INF_H}}; \code{\link{M_M_1_K}};
  \code{\link{M_M_1}}; \code{\link{M_M_S_INF_H_Y}};
  \code{\link{M_M_S_INF_H}}; \code{\link{M_M_S_K}};
  \code{\link{M_M_S}}; \code{\link{OpenJacksonNetwork}}
}

