\name{transactions-class}
\docType{class}
\alias{transactions-class}
\alias{[,transactions-method}
\alias{coerce,matrix,transactions-method}
\alias{coerce,list,transactions-method}
\alias{coerce,transactions,matrix-method}
\alias{coerce,transactions,list-method}
\alias{coerce,data.frame,transactions-method}
\alias{image,transactions-method}
\alias{labels,transactions-method}
\alias{transactionInfo<-,transactions-method}
\alias{transactionInfo,transactions-method}
\alias{transactionInfo<-}
\alias{transactionInfo}
\alias{show,transactions-method}
\alias{summary,transactions-method}
\alias{summary.transactions-class}
\alias{show,summary.transactions-method}

\title{Class ``transactions'' --- Binary Incidence Matrix for
  Transactions}
\description{
  The \code{transactions} class represents transaction data used for
  mining itemsets or rules.  It is a direct extension of class
  \code{\link[itemMatrix-class]{itemMatrix}} to store a binary incidence
  matrix, item labels, and optionally transaction IDs and user IDs.
}
\section{Objects from the Class}{
  Objects are created by coercion from objects of other classes or by
  calls of the form \code{new("transactions", ...)}.
 }
\section{Slots}{
  \describe{
    \item{\code{transactionInfo}:}{object of class \code{"data.frame"}
      with vectors of the same length as the number of
      transactions.  Each vector can hold additional information, e.g.,
      store transaction IDs or user IDs for each transaction.}
    \item{\code{data}:}{object of class
      \code{\link[Matrix:dgCMatrix-class]{dgCMatrix}} to store the
      binary incidence matrix (see
      \code{\link[itemMatrix-class]{itemMatrix}} class)} 
    \item{\code{itemInfo}:}{object of class \code{"data.frame"} to store 
      item labels (see \code{\link[itemMatrix-class]{itemMatrix}} class)}
  }
}
\section{Extends}{
  Class \code{\link[itemMatrix-class]{itemMatrix}}, directly.
}
\section{Methods}{
  \describe{
    \item{[}{\code{signature(x = "transactions")};
      extracts a subset from the incidence matrix.  The first argument
      extracts transactions and the second argument can be used to
      extract a subset of items (using item IDs)}
    \item{coerce}{\code{signature(from = "matrix", to = "transactions")};
      produces a transactions data set from a binary incidence matrix. 
      The row names are used as item labels and the column names are
      stores as transaction IDs.
    }
    \item{coerce}{\code{signature(from = "list", to = "transactions")};
      produces a transactions data set from a list.  The names of the
      items in the list are used as item labels and the item IDs and the 
      incidence matrix is produced automatically.
    }
    \item{coerce}{\code{signature(from = "transactions", to = "matrix")}}
    \item{coerce}{\code{signature(from = "transactions", to = "list")}}
    \item{coerce}{\code{signature(from = "data.frame", to = "transactions")}; 
      recodes the data frame containing only categorical variables (all
      have to be factors) into a binary transaction data set.  The needed
      number of dummy items are automatically generated.  The item
      labels are generated by concatenating variable names and levels with
      a \samp{"="}.   
      The variable names and levels are stored in the labels data frame
      as the components \code{variables} and \code{levels}.}
    \item{image}{\code{signature(x = "transactions")};
      plots an image of the transactions for visual inspection}
    \item{labels}{\code{signature(x = "transactions")};
      returns the labels (item labels and transaction IDs) 
      for the incidence matrix as a list of two vectors named \code{items}
      and \code{transactionIDs}.}
    \item{transactionInfo<-}{\code{signature(x = "transactions")};
      replaces the transactionInfo data frame}
    \item{transactionInfo}{\code{signature(x = "transactions")};
      returns transactionInfo}
    \item{show}{\code{signature(object = "transactions")}}
    \item{summary}{\code{signature(object = "transactions")}}
  }
}
\author{
  Michael Hahsler
}
\seealso{
  \code{\link{itemMatrix-class}}
}
\examples{
data <- list(
      c("a","b","c"),
      c("a","b"),
      c("a","b","d"),
      c("c","e"),
      c("a","b","d","e"),
      )

names(data) <- paste("Tr",c(1:5), sep = "")

### coerce data into transactins
trans <- as(data, "transactions")

### analyze transactions
summary(trans)
image(trans)
}
\keyword{classes}
