\name{plotComparison}
\alias{plotComparison}

\title{Dataset comparison plot}

\description{
  This function compares two datasets with respect to a previously computed statistic and by plotting them in a histogram or QQ-plot.
  The function 'expressionStats' computes the list of statitics which are used as input for this function.
}

\usage{plotComparison(results.1, results.2, name.1, name.2, stat, type = "both",
  extendedAbsoluteIntensity = FALSE, bins = NA)}

\arguments{
  \item{results.1}{
  A list of statistics generated by the function 'expressionStats'.
}
  \item{results.2}{
  A list of statistics generated by the function 'expressionStats'.
}
  \item{name.1}{
  The name of the first dataset represented by 'results.1'.
}
  \item{name.2}{
  The name of the second dataset represented by 'results.2'.
}
  \item{stat}{
  Specifies which comparison to plot. Must be one of the following:
  Replicate.noise.distribution
  Absolute.intensity.distribution
  Range.of.gene.expression
  Silhouette.coefficient.genes
  Silhouette.coefficient.microarrays
  TF.TG.correlation
  TF.TG.correlation.enrichment
  TG.TG.correlation
  TG.TG.correlation.enrichment
  TF.activity.distribution
}
  \item{type}{
  Specifies whether histograms, qq-plots or both should be plotted. Must be on of 'both', 'hist', 'qq'. Defaults to 'both'.
}
  \item{extendedAbsoluteIntensity}{
  logical. If 'stat' is 'Absolute.intensity.distribution' and 'extendedAbsoluteIntensity' is TRUE, individual examples will be added to the histogram.
  If 'stat' is not 'Absolute.intensity.distribution', there is no effect.
}
  \item{bins}{
  Specifies the number of bins to use for a histogram. If the default of NA is used, an appropriate value is used for each histogram, as specified in 'getDefaults()'.
}
}

\author{Robert Maier}

\seealso{
\code{plotAll}
\code{getAllScores}
\code{expressionStats}
}

\examples{
data(GNW.s.expression.data)
data(GNW.s.network)
data(GNW.s.exp.group)
results <- expressionStats(GNW.s.expression.data[,1:200],
  GNW.s.network, GNW.s.exp.group)
results.p <- expressionStats(GNW.s.expression.data[,1:200],
  GNW.s.network, GNW.s.exp.group, permute.genes=TRUE)
plotComparison(results, results.p, 'n.normal', 'n.permuted',
  'Absolute.intensity.distribution', type='both')
}
