% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_ttest.R
\name{parTest2}
\alias{parTest2}
\title{Parameter t-test}
\usage{
parTest2(bdObj, group, vals = NULL)
}
\arguments{
\item{bdObj}{Object of class \code{bdObj}}

\item{group}{Length one character of grouping column in which to perform t-test}

\item{vals}{Character vector of values within grouping column in which to perform the
test. If \code{NULL}, it will do all pairwise tests}
}
\value{
List of t-test results of class \code{bdotsPars_ttest}
}
\description{
Perform t-test on curve parameters of bdotsFit object
}
\details{
Performs pairwise t-test. Currently only tests at alpha = 0.95. Also
currently only allows t-test within single grouping column. Ability to test
across grouping columns to come later
}
\examples{
\dontrun{
res <- bdotsFit(data = cohort_unrelated,
                subject = "Subject",
                time = "Time",
                y = "Fixations",
                group = c("Group", "LookType"),
                curveType = doubleGauss(concave = TRUE),
                cor = TRUE,
                numRefits = 2,
                cores = 0,
                verbose = FALSE)
tstats <- parTest(res, group = "LookType", vals = c("Cohort", "Unrelated_Cohort"))
}
}
