% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdsummary.R
\name{bdsummary}
\alias{bdsummary}
\title{Provides summary of biodiversity data}
\usage{
bdsummary(indf)
}
\arguments{
\item{indf}{input data frame containing biodiversity data set}
}
\description{
Calculates some general indicators of the volume, spatial, temporal and
taxonomic aspects of the provided data set.
}
\details{
The function returns information on the volume of the data set (number of
records), temporal coverage (minimum and maximum dates), taxonomic coverage
(brief breakdown of the records by taxonomic levels) and spatial coverage
(coordinates of the edges of the bounding box containing all records and
division of covered area in degree cells) of the records.

To update spatial grid data to dataset, please use \link{format_bdvis} or 
\link{getcellid} function before using bdsummary.
}
\examples{
\dontrun{
require(rinat)
inat<-get_inat_obs_project("reptileindia") 
bdsummary(inat)
}
}
\seealso{
Other Data preparation functions: 
\code{\link{format_bdvis}()},
\code{\link{getcellid}()},
\code{\link{gettaxo}()}
}
\concept{Data preparation functions}
