% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/construct_ngrams.R
\name{construct_ngrams}
\alias{construct_ngrams}
\title{Construct and filter n-grams}
\usage{
construct_ngrams(target, seq, u, n_max, conf_level = 0.95, gap = TRUE)
}
\arguments{
\item{target}{\code{integer} vector with target information (e.g. class labels).}

\item{seq}{a vector or matrix describing sequence(s).}

\item{u}{\code{integer}, \code{numeric} or \code{character} vector of all
possible unigrams.}

\item{n_max}{size of constructed n-grams.}

\item{conf_level}{confidence level.}

\item{gap}{\code{logical}, if \code{TRUE} gap are used. See Details.}
}
\value{
a vector of n-grams.
}
\description{
Step-by-step builds and selects important n-grams. \code{construct_ngrams} extracts
unigrams from the sequences and filters significant features (with p-value below
\code{conf_level}).
}
\details{
Gap parameter determines if \code{construct_ngrams} performs feature
selection on exact n-grams (\code{gap} equal to FALSE) or on all features in the
Hamming distance 1 from the n-gram (\code{gap} equal to TRUE).
}
\examples{
\donttest{
deg_seqs <- degenerate(human_cleave[, 1L:9],
list(`1` = c(1, 6, 8, 10, 11, 18),
     `2` = c(2, 13, 14, 16, 17),
     `3` = c(5, 19, 20),
     `4` = c(7, 9, 12, 15),
     '5' = c(3, 4)))
bigrams <- construct_ngrams(human_cleave[, "tar"], deg_seqs, 1L:5, 2)
}
}
\seealso{
Feature filtering method: \code{\link{test_features}}.
}

