% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Evaluate.models.R
\name{Find.Optim.Stat}
\alias{Find.Optim.Stat}
\title{Calculate the best score according to a given evaluation method}
\usage{
Find.Optim.Stat(Stat='TSS',
                  Fit,
                  Obs,
                  Nb.thresh.test = 100,
                  Fixed.thresh = NULL)
}
\arguments{
\item{Stat}{either 'ROC', TSS', 'KAPPA', 'ACCURACY', 'BIAS', 'POD', 'FAR', 
'POFD', 'SR', 'CSI', 'ETS', 'HK', 'HSS', 'OR' or 'ORSS'}

\item{Fit}{vector of fitted values (continuous)}

\item{Obs}{vector of observed values (binary)}

\item{Nb.thresh.test}{integer, the numer of thresholds tested over the 
range of fitted value}

\item{Fixed.thresh}{integer, if not \code{NULL}, the only threshold value tested}
}
\value{
A 1 row x 4 column \code{matrix} :
  \itemize{
    \item{\code{best.iter}:}{ the best score obtained for chosen statistic}
    \item{\code{cutoff}:}{ the associated cut-off used for transform fitted vector into binary}
    \item{\code{sensibility}:}{ the sensibility with this threshold}
    \item{\code{specificity}:}{ the specificity with this threshold}
  }
}
\description{
\code{Find.Optim.Stat} is an internal \pkg{biomod2} function 
to find the threshold to convert continuous values into binary ones leading 
to the best score for a given evaluation metric.
}
\details{
Please refer to \code{\link[biomod2]{BIOMOD_Modeling}} to get more information about this metrics.
  If you give a \code{Fixed.thresh}, no optimisation will be done. Only the score for this threshold will be returned.
}
\examples{
  a <- sample(c(0,1),100, replace=TRUE)
                
  ##' random drawing
  b <- runif(100,min=0,max=1000)
  Find.Optim.Stat(Stat='TSS',
                  Fit=b,
                  Obs=a)
                
  ##' biased drawing
  BiasedDrawing <- function(x, m1=300, sd1=200, m2=700, sd2=200){
    return(ifelse(x<0.5, rnorm(1,m1,sd1), rnorm(1,m2,sd2)))
  }
                
  c <- sapply(a,BiasedDrawing)
                
  Find.Optim.Stat(Stat='TSS',
                  Fit=c,
                  Obs=a,
                  Nb.thresh.test = 100)  
                
                
}
\author{
Damien Georges
}
\seealso{
\code{\link[biomod2]{BIOMOD_Modeling}}, 
  \code{\link[biomod2]{getStatOptimValue}}, 
  \code{\link[biomod2]{calculate.stat}}
}
\keyword{evaluate,}
\keyword{evaluation}
\keyword{models,}
\keyword{options,}

