% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R
\name{c.booltype}
\alias{c.booltype}
\alias{c.bit}
\alias{c.bitwhich}
\title{Concatenating booltype vectors}
\usage{
\method{c}{booltype}(...)

\method{c}{bit}(...)

\method{c}{bitwhich}(...)
}
\arguments{
\item{\dots}{\code{\link{booltype}} vectors}
}
\value{
a vector with the lowest input \code{\link{booltype}} (but not lower than\code{\link{logical}})
}
\description{
Creating new boolean vectors by concatenating boolean vectors
}
\examples{
 c(bit(4), !bit(4))
 c(bit(4), !bitwhich(4))
 c(bitwhich(4), !bit(4))
 c(ri(1,2,4), !bit(4))
 c(bit(4), !logical(4))
 message("logical in first argument does not dispatch: c(logical(4), bit(4))")
 c.booltype(logical(4), !bit(4))

}
\seealso{
\code{\link{c}}, \code{\link{bit}} , \code{\link{bitwhich}},  , \code{\link{which}}
}
\author{
Jens Oehlschlägel
}
\keyword{classes}
\keyword{logic}
