% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data-statistics.R
\name{cmi}
\alias{cmi}
\title{Returns the (conditional) mutual information among two variables.}
\usage{
cmi(x, y, dataset, z = NULL, unit = "log")
}
\arguments{
\item{x}{A length one character.}

\item{y}{A length one character.}

\item{dataset}{A data frame. Must contain x, y and, optionally, z columns.}

\item{z}{A character vector.}

\item{unit}{A character. Logarithm base. See \code{entropy} package.}
}
\description{
If \code{z} is not \code{NULL} then returns \eqn{I(X;Y|Z)}. Otherwise
\eqn{I(X;Y)}.
}
\details{
\eqn{I(X;Y|Z) = H(X|Z) + H(Y|Z) - H(X,Y,Z) - H(Z)}, where \eqn{H()} is
Shannon's entropy.
}

