% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkNode.R
\name{linkNode}
\alias{linkNode}
\alias{linkMultiple}
\title{Link nodes to spatial data}
\usage{
linkNode(layer, network, node, intervals, categorical = NULL,
  field = NULL, verbose = TRUE, spatial = TRUE)

linkMultiple(spatialData, network, lookup, field = NULL,
  verbose = TRUE)
}
\arguments{
\item{layer}{character (path to file) or an object of class "RasterLayer", 
"sf" or "SpatialPolygonsDataFrame". The spatial data corresponding to the network node as by argument \code{node}.}

\item{network}{The Bayesian network. An object of class \code{grain}, or a character (the path to the \emph{.net} file to be loaded)}

\item{node}{character. The network node to be coupled with the file/object indicated by \code{layer} argument}

\item{intervals}{A list of numeric vectors. For categorical variables the spatial data values associated to each state of the node, 
for continuous variables the boundary values dividing into the corresponding states, including upper and lower boundaries.}

\item{categorical}{logical, or NULL. Is the node a categorical variable? If NULL the function will attempt to assign the 
logical value by looking at \code{intervals} argument.}

\item{field}{character. Only for spatial vector data (e.g. shapefile), the field/column names in 
the attribute table corresponding to the nodes, ordered accordingly.}

\item{verbose}{logical. If \code{verbose = TRUE} a summary of class boundaries and associated nodes and data will be printed 
to screen for checks.}

\item{spatial}{logical. Should the output list include the input as raster or spatial vector? 
Default is TRUE, returning the list with an object of class "RasterLayer" or "sf" for each node associated. 
If FALSE, returns only the values.}

\item{spatialData}{character with path to one or more raster files or to a single spatial vector file, or a list of objects of 
class 'RasterLayer' (for raster), or a single object of class 'sf' or 'SpatialPolygonsDataFrame' (for spatial vector). 
The spatial data associated to given network nodes, provided as file paths or as (list of) spatial objects. Items must be ordered 
accordingly to the corresponding nodes listed in \code{lookup}, 
or provided as named list, where names match exactly to the corresponding nodes name.}

\item{lookup}{character (path to file) or a formatted list. This argument can be provided as path to a comma separated file or a formatted list (see \code{\link{setClasses}} )}
}
\value{
\code{linkNode} returns a list of objects, including the spatial data and the related node information. \cr
\code{linkMultiple} returns a list of lists. Each element of the list includes the spatial data and summary information for each of the input nodes.
}
\description{
\code{linkNode} links a node of the Bayesian network to the corresponding spatial data, returning a list of objects, 
including the spatial data and relevant info about the node.\cr
\code{linkMultiple} operates on multiple nodes and related spatial data.
}
\details{
In future releases, this function may be rewritten to provide an S4/S3 object.
}
\examples{
## Load data into global environment
list2env(ConwyData, environment())
lookup <- LUclasses

network <- LandUseChange
ln <- linkNode(layer=ConwyLU, network, node='CurrentLULC', intervals=c(2, 3, 1))
ln

## Link the Bayesian network to multiple spatial data at once, using a lookup list
spatialData <- c(ConwyLU, ConwySlope, ConwyStatus)
linkMultiple(spatialData, network, lookup, verbose = FALSE)

## Method for spatial vectorial data (i.e. class 'sf' or 'SpatialPolygon')
spatialData <- system.file("extdata", "Conwy.shp", package = "bnspatial")
lst <- linkMultiple(spatialData, network, lookup, field= c('LU', 'Slope', 'Status'))
lst

}
\seealso{
\code{\link{dataDiscretize}}; \code{\link{setClasses}}
}
