% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_write.R
\name{box_write}
\alias{box_write}
\title{Write R Objects to Files Remotely Hosted on box.com}
\usage{
box_write(x, filename, dir_id = box_getwd(), description = NULL,
  write_fun = rio::export, ...)
}
\arguments{
\item{x}{An R object}

\item{filename}{The name for the file to be uploaded}

\item{dir_id}{If uploading, the box.com folder id that you'd like to upload
to.}

\item{description}{Optional. \code{character}. A string to be used as the
description caption for the file (added via 
\code{\link{box_add_description}}). Useful for describing the contents of a
file, or describing the latest changes made to it. If \code{NULL} (the 
default), no description is added.}

\item{write_fun}{The function used to write the R object to a file}

\item{...}{Additional arguments passed to \code{read_fun}}
}
\value{
An object of class 
  \code{\link[=boxr_S3_classes]{boxr_file_reference}}.
}
\description{
{
  A fast and lazy way to upload R objects to box.com in a commonly readable
  file format. \code{read_fun} is used to convert R objects to files, which
  by default is the \code{\link{export}} function from the \code{rio} 
  package.
  
  \code{\link{rio}}'s \code{\link[rio]{export}} function currently only 
  supports \code{data.frame}s; for lists \code{\link[jsonlite]{toJSON}} may 
  be more appropriate.
  
  Note: \code{box_write} is for writing files in standard formats to box.com.
  To upload R objects as \code{.RData} files, see \code{\link{box_save}}.
}
}
\author{
Brendan Rocks \email{rocks.brendan@gmail.com}
}

