% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_random_graphs.R
\name{analysis_random_graphs}
\alias{analysis_random_graphs}
\title{Perform an analysis with random graphs for brain MRI data}
\usage{
analysis_random_graphs(g.list, N = 100, savedir = ".", ...)
}
\arguments{
\item{g.list}{List of lists containing \code{igraph} graph objects}

\item{N}{Integer specifying number of random graphs to generate per
individual graph (default: 100)}

\item{savedir}{Character string specifying the directory in which to save the
generated graphs (default: current working directory)}

\item{...}{Other arguments passed to \code{\link{sim.rand.graph.par}} (e.g.
\code{clustering=T})}
}
\value{
A list containing:
\item{rich}{A data table containing normalized rich-club coefficients and
  p-values}
\item{small}{A data table with small-world parameters}
\item{rand}{A data table with some global graph measures for all random
  graphs generated}
}
\description{
This function is not quite a "proper" function. It performs the steps needed
for doing typical graph theory analyses with brain MRI data if you need to
generate equivalent random graphs. This includes calculating \emph{small
world} parameters and normalized \emph{rich club} coefficients.
}
\details{
The steps that are performed are:
\enumerate{
  \item \code{N} random graphs are generated for each group and
    density/threshold (and subject if you have subject-specific graphs).
  \item These graphs are all written to disk in \code{savedir}. All of these
    are read back into \code{R} and combined into lists; these lists are also
    written to disk (in a sub-directory named \code{ALL}), so you can delete
    the individual \code{.rds} files afterwards.
  \item \emph{Small world} parameters are calculated, along with values for
    a few global graph measures that may be of interest.
  \item \emph{Normalized rich club coefficients} and associated p-values will
    be calculated.
}
}
\examples{
\dontrun{
rand_all <- analysis_random_graphs(g.norm, 1e2,
  savedir='/home/cwatson/dti/rand', clustering=F)
}
}
\seealso{
\code{\link{small.world}}

Other Random graph functions: \code{\link{RandomGraphs}},
  \code{\link{RichClub}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
