% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_matrix.R
\name{corr.matrix}
\alias{corr.matrix}
\title{Calculate correlation matrix and threshold}
\usage{
corr.matrix(resids, densities, thresholds = NULL, what = c("resids", "raw"),
  exclude.reg = NULL, type = c("pearson", "spearman"), rand = FALSE)
}
\arguments{
\item{resids}{An object of class \code{brainGraph_resids} (the output from
\code{\link{get.resid}})}

\item{densities}{Numeric vector indicating the resultant network
density(ies); keeps the top \emph{X}\% of correlations}

\item{thresholds}{Numeric; absolute correlation value to threshold by
(default: \code{NULL})}

\item{what}{Character string indicating whether to correlate the residuals or
the raw structural MRI values (default: \code{'resids'})}

\item{exclude.reg}{Character vector of regions to exclude (default:
\code{NULL})}

\item{type}{Character string indicating which type of correlation coefficient
to calculate (default: \code{'pearson'})}

\item{rand}{Logical indicating whether the function is being called for
permutation testing; not intended for general use (default: \code{FALSE})}
}
\value{
A nested list containing a list for all subject groups; each of these
  has the following components:
  \item{R}{Numeric matrix of correlation coefficients.}
  \item{P}{Numeric matrix of p-values.}
  \item{r.thresh}{A 3-d binary array indicating correlations that are above a
    certain threshold. The length of the 3rd dimension equals the number of
    thresholds/densities supplied.}
  \item{thresholds}{Numeric vector; the thresholds supplied.}
  \item{densities}{Numeric vector; the densities supplied.}
  \item{what}{Residuals or raw values}
  \item{exclude.reg}{Excluded regions (if any)}
  \item{type}{Pearson or Spearman}
}
\description{
\code{corr.matrix} calculates the correlation between all column pairs of a
given data frame, and thresholds the resultant correlation matrix based on a
given density (e.g., \code{0.1} if you want to keep only the 10\% strongest
correlations). If you want to threshold by a specific correlation coefficient
(via the \code{thresholds} argument), then the \code{densities} argument is
ignored.
}
\details{
If you wish to exclude regions from your analysis, you can give the indices
of their columns with the \code{exclude.reg} argument.

By default, the Pearson correlation coefficients are calculated, but you can
return Spearman by changing the \code{type} argument.
}
\examples{
\dontrun{
myResids <- get.resid(lhrh, covars)
corrs <- corr.matrix(myResids, densities=densities)))
}
}
\seealso{
\code{\link[Hmisc]{rcorr}}

Other Structural covariance network functions: \code{\link{IndividualContributions}},
  \code{\link{brainGraph_boot}},
  \code{\link{brainGraph_init}},
  \code{\link{brainGraph_permute}},
  \code{\link{get.resid}},
  \code{\link{plot.brainGraph_resids}},
  \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
