% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainGraph_mediate.R
\name{Mediation}
\alias{Mediation}
\alias{brainGraph_mediate}
\alias{summary.bg_mediate}
\alias{bg_to_mediate}
\title{Mediation analysis with brain graph measures as mediator variables}
\usage{
brainGraph_mediate(g.list, covars, mediator, treat, outcome, covar.names,
  level = c("graph", "vertex"), boot = TRUE, boot.ci.type = c("perc",
  "bca"), N = 1000, conf.level = 0.95, control.value = 0,
  treat.value = 1, long = TRUE, int = FALSE,
  .progress = getOption("bg.progress"), ...)

\method{summary}{bg_mediate}(object, mediate = FALSE, region = NULL,
  digits = max(3L, getOption("digits") - 2L), ...)

bg_to_mediate(x, region = NULL)
}
\arguments{
\item{g.list}{A \code{brainGraphList} object}

\item{covars}{A data table containing covariates of interest. It must include
columns for \emph{Study.ID}, the treatment variable, \code{covar.names},
and the outcome variable.}

\item{mediator}{Character string; the name of the graph measure acting as
the \emph{mediating} variable}

\item{treat}{Character string; the \emph{treatment} variable (e.g.,
\emph{Group})}

\item{outcome}{Character string; the name of the outcome variable of interest
(e.g., full-scale IQ, memory, etc.)}

\item{covar.names}{Character vector of the column names in \code{covars} to
include in the models as pre-treatment covariates.}

\item{level}{Character string; either \code{vertex} (default) or
\code{graph}}

\item{boot}{Logical indicating whether or not to perform bootstrapping
(default: \code{TRUE})}

\item{boot.ci.type}{Character string; which type of CI's to calculate
(default: \code{perc})}

\item{N}{Integer; the number of bootstrap samples to run (default:
\code{1e3})}

\item{conf.level}{Numeric; the level of the CI's to calculate (default:
\code{0.95} for the 2.5 and 97.5 percentiles)}

\item{control.value}{Value of \code{treat} to be used as the control
condition (default: \code{0})}

\item{treat.value}{Value of \code{treat} to be used as the treatment
condition (default: \code{1})}

\item{long}{Logical indicating whether or not to return all bootstrap samples
(default: \code{TRUE})}

\item{int}{Logical indicating whether or not to include an interaction of the
mediator and treatment (default: \code{FALSE})}

\item{.progress}{Logical indicating whether to print a progress bar. Default:
\code{getOption('bg.progress')}}

\item{...}{Other arguments passed to \code{\link{brainGraph_GLM_design}}
(e.g., \code{binarize}) (unused in the \code{summary} method)}

\item{object}{A \code{bg_mediate} object}

\item{mediate}{Logical indicating whether or not to use the \code{summary}
method from \code{\link[mediation]{mediate}} (default: \code{FALSE}). If
\code{TRUE}, only a single region can be printed.}

\item{region}{Character string specifying which region's results to
summarize; only relevant if \code{level='vertex'} (default: \code{NULL})}

\item{digits}{Integer specifying the number of digits to display for P-values}

\item{x}{Object output from \code{\link{brainGraph_mediate}}}
}
\value{
An object of class \code{bg_mediate} with elements:
  \item{level}{Either \code{graph} or \code{vertex}.}
  \item{removed.subs}{A character vector of Study.ID's removed due to
    incomplete data}
  \item{X.m, X.y}{Design matrices for the model with the mediator as the
    outcome variable (\code{X.m}) and for the model with the mediator as an
    additional predictor (\code{X.y})}
  \item{y.m, y.y}{Outcome variables for the associated design matrices above.
    \code{y.m} will be a matrix of size \emph{# subj. X # regions}}
  \item{res.obs}{A \code{data.table} of the observed values of the point
    estimates.}
  \item{res.ci}{A \code{data.table} of the confidence intervals for the
    effect estimates.}
  \item{res.p}{A \code{data.table} of the two-sided p-values for the effect
    estimates}
  \item{boot}{Logical, the \code{boot} argument.}
  \item{boot.ci.type}{Character string indicating which type of bootstrap
    confidence intervals were calculated.}
  \item{res.boot}{A \code{data.table} with \code{N} rows of the bootstrap
    results for all effects.}
  \item{treat}{Character string of the treatment variable.}
  \item{mediator}{Character string of the mediator variable.}
  \item{outcome}{Character string of the outcome variable.}
  \item{covariates}{Returns \code{NULL}; not used in this package.}
  \item{INT}{Logical indicating whether the models included an interaction
    between treatment and mediator.}
  \item{conf.level}{The confidence level.}
  \item{control.value}{The value of the treatment variable used as the
    control condition.}
  \item{treat.value}{The value of the treatment variable used as the
    treatment condition.}
  \item{nobs}{Integer; the number of observations in the models.}
  \item{sims}{Integer; the number of bootstrap replications.}
  \item{covar.names}{The pre-treatment covariate names.}

\code{bg_to_mediate} returns an object of class \code{mediate}
}
\description{
\code{brainGraph_mediate} performs simple mediation analyses in which a given
graph- or vertex-level measure (e.g., \emph{weighted global efficiency})
is the mediator \emph{M}. The outcome (or dependent/response) variable
\emph{Y} can be a neuropsychological measure (e.g., \emph{IQ}) or
can be a disease-specific metric (e.g., recovery time). The treatment
variable should be a \code{factor}.

\code{\link{bg_to_mediate}} converts the results into an object of class
\code{\link[mediation]{mediate}}. In \code{brainGraph}, it is only used for
the \code{\link[mediation]{summary.mediate}} method, but you can similarly
use its output for the \code{\link[mediation]{plot.mediate}} method.
}
\details{
This code was adapted closely from \code{\link[mediation]{mediate}} in the
\code{mediation} package, and the procedure is exactly the same as theirs
(see the references listed below). So, if you use this function, please cite
their work.

As of \code{brainGraph v2.0.0}, this function has been tested only for a
treatment (independent) variable \emph{X} being a 2-level factor (e.g.,
disease group, old vs. young, etc.).

Allowing for treatment-mediator interaction (setting \code{int=TRUE})
currently will only work properly if the mediator is a continuous variable;
since the mediator is always a graph metric, this should always be the case.
}
\examples{
\dontrun{
med.EglobWt.FSIQ <- brainGraph_mediate(g[[5]], covars.med, 'E.global.wt',
  'Group', 'FSIQ', covar.names=c('age', 'gender'), N=1e4)
med.strength.FSIQ <- brainGraph_mediate(g[[5]], covars.med, 'strength',
  'Group', 'FSIQ', covar.names=c('age', 'gender'), level='vertex')
}
}
\references{
Tingley, D. and Yamamoto, T. and Hirose, K. and Keele, L. and
  Imai, K. (2014) mediation: R package for causal mediation analysis.
  \emph{Journal of Statistical Software}, \bold{59(5)}, 1--38.
  \url{https://dx.doi.org/10.18637/jss.v059.i05}

Imai, K. and Keele, L. and Yamamoto, T. (2010) Identification
  inference, and sensitivity analysis for causal mediation effects.
  \emph{Statistical Science}, \bold{25(1)}, 51--71.
  \url{https://dx.doi.org/10.1214/10-STS321}

Imai, K. and Keele, L. and Tingley, D. (2010) A general approach
  to causal mediation analysis. \emph{Psychological Methods}, \bold{15(4)},
  309--334. \url{https://dx.doi.org/10.1037/a0020761}

Imai, K. and Keele, L. and Tingley, D. and Yamamoto, T. (2011)
  Unpacking the black box of causality: learning about causal mechanisms from
  experimental and observational studies. \emph{American Political Science
  Review}, \bold{105(4)}, 765--789.
  \url{https://dx.doi.org/10.1017/S0003055411000414}

Imai, K. and Yamamoto, T. (2013) Identification and sensitivity
  analysis for multiple causal mechanisms: revisiting evidence from framing
  experiments. \emph{Political Analysis}, \bold{21(2)}, 141--171.
  \url{https://dx.doi.org/10.1093/pan/mps040}
}
\seealso{
\code{\link[mediation]{mediate}}

Other Group analysis functions: \code{\link{Bootstrapping}},
  \code{\link{GLM}}, \code{\link{NBS}},
  \code{\link{brainGraph_permute}}, \code{\link{mtpc}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Group analysis functions}
