% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Utility functions}
\alias{Utility functions}
\alias{get_metadata}
\alias{outer_vec}
\alias{split_string}
\alias{vec.transform}
\title{Utility functions}
\usage{
get_metadata(object)

outer_vec(x, y)

split_string(x, max_len = 80L, delim = "\\\\+", sep = "\\n")

vec.transform(x, min.val = 0, max.val = 1)
}
\arguments{
\item{object}{A list-like object}

\item{x}{A character string}

\item{delim}{Character specifying where to end a line if it is longer than
\code{max.len}. Default: \code{'+'}}

\item{sep}{Character specifying what to split by. Default: \code{'\n'} (a
newline character)}

\item{min.val}{the minimum value of the new range}

\item{max.val}{the maximum value of the new range}

\item{max.len}{Integer; the max length of one line. Default: 80}
}
\value{
\code{get_metadata} - the same object with version, system, and date
  information added

A vector of the transformed input.
}
\description{
\code{get_metadata} adds metadata to a list-like object.

\code{outer_vec} simply performs the cross-product, specifically \code{x %*%
t(y)}, and assigns dimnames to the resulting matrix.

\code{split_string} inserts separator characters in a character string to
truncate strings for printing.

\code{vec.transform} takes a vector and transforms it to have a new range,
given the input, or the default values of [0, 1].
}
\details{
If the object is a graph, graph-level attributes will be added. The
elements added are:
\itemize{
  \item{version}{A list with R, brainGraph, and igraph versions}
  \item{sys}{Character vector of system information}
  \item{date}{The date and time of creation}
}

The \code{delim} argument determines \emph{where} to insert the separator.
For example, given the default, it will attempt to insert newline characters
only following a plus sign.
}
\keyword{internal}
